/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.validate;

import com.mulesoft.connector.as2.internal.crypto.SignedMessageVerifier;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.SignedMimeMultipart;
import com.mulesoft.connector.as2.internal.mime.validate.MimePartValidator;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMimeMultipartValidator
implements MimePartValidator<SignedMimeMultipart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMimeMultipartValidator.class);
    private SignedMessageVerifier verifier;
    private String calculatedHash;

    public SignedMimeMultipartValidator withPublicKey(PublicKey publicKey) {
        this.verifier = new SignedMessageVerifier(publicKey);
        return this;
    }

    SignedMimeMultipartValidator withSignedMessageVerifier(SignedMessageVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    @Override
    public boolean canValidate(String contentType) {
        LOGGER.debug(String.format("The contentType value must start with multipart/signed and the value is: %s", contentType));
        return contentType != null && contentType.toLowerCase().startsWith("multipart/signed");
    }

    @Override
    public void validate(SignedMimeMultipart signedMimeMultipart) {
        try {
            LOGGER.trace("Validating signature of signed MIME multipart.");
            if (!this.verifier.validateSignature(signedMimeMultipart.getPKCS7Signature(), signedMimeMultipart.getContentDigest())) {
                throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Signature of signed MIME message failed validation", AS2ErrorType.SIGNATURE_VERIFY);
            }
        }
        catch (Exception e) {
            if (e instanceof AS2ExtensionException) {
                throw e;
            }
            String validationError = String.format("Signature validation failed with the following error:\n%s", e.getMessage());
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, validationError, AS2ErrorType.SIGNATURE_VERIFY, e);
        }
        this.calculatedHash = this.verifier.getHash();
        LOGGER.trace("calculatedHash is done.");
    }

    public String getCalculatedHash() {
        return this.calculatedHash;
    }
}

