/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.receive;

import com.mulesoft.connector.as2.internal.enums.RequiredSecurityLevel;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MDNBuilder;
import com.mulesoft.connector.as2.internal.receive.AbstractReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandler;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.ReceivedMessageInfo;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import com.mulesoft.connector.as2.internal.receive.SignedMimeMessageAttributes;
import java.io.InputStream;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveAsyncMDNHandler
extends ReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveAsyncMDNHandler.class);

    @Override
    public void receiveAS2Message(CaseInsensitiveMultiMap httpHeaders, InputStream content, AbstractReceiveAttributesBuilder attributesBuilder, RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, boolean doNonRepudiation, RequiredSecurityLevel requiredSecurityLevel) {
        callback.notifyReadyForOkHttpResponse();
        super.receiveAS2Message(httpHeaders, content, attributesBuilder, requestKeyStore, callback, doNonRepudiation, requiredSecurityLevel);
    }

    @Override
    protected boolean shouldAddReceiptDeliveryOption() {
        return true;
    }

    @Override
    protected void notifyResultMDN(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, boolean processed, MimePart receivedMimePart) {
        LOGGER.debug("Building MDN. Information is required");
        AS2MDNBuilder mdnBuilder = new AS2MDNBuilder().withRequestKeyStore(requestKeyStore).withBoundaryIdentifierGeneratorFactory(this.getBoundaryIdentifierGeneratorFactory()).withReceiveMessageInfo(messageInfo).withDispositionType(dispositionType).withProcessed(processed).withHeaders(true).withReceiptDeliveryOption(this.shouldAddReceiptDeliveryOption());
        callback.notifyAsyncMDNResult(messageInfo.getContent(), signedMimeMessageAttributes, dispositionType, receivedMimePart, mdnBuilder);
    }
}

