/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.crypto.AS2Signature;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.MimeMultipartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.SignatureMimePartBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMimeMultipartBuilder
extends MimeMultipartBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMimeMultipartBuilder.class);
    private AS2Digest as2Digest;
    private MimePart signaturePart;
    private PrivateKey privateKey;
    private Certificate selfCertificate;
    private EncodingType encoding;
    private boolean propagateContentType;

    @Override
    public SignedMimeMultipartBuilder withContentTransferEncoding(EncodingType encoding) {
        if (this.propagateContentType) {
            this.encoding = encoding;
            super.withContentTransferEncoding(encoding);
        } else {
            this.encoding = EncodingType.BASE64;
        }
        return this;
    }

    public SignedMimeMultipartBuilder withPropagateContentType(boolean propagateContentType) {
        this.propagateContentType = propagateContentType;
        return this;
    }

    public SignedMimeMultipartBuilder withDigest(AS2Digest as2Digest) {
        this.as2Digest = as2Digest;
        return this;
    }

    public SignedMimeMultipartBuilder withPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public SignedMimeMultipartBuilder withSelfCertificate(Certificate certificate) {
        this.selfCertificate = certificate;
        return this;
    }

    @Override
    public MimePart build() {
        LOGGER.trace("Building Signed Mime Multipart...");
        this.validateReadyToBuild();
        LOGGER.trace("Making As2Signature.");
        AS2Signature as2Signature = new AS2Signature().withPrivateKey(this.privateKey).withDigest(this.as2Digest);
        this.signaturePart = new SignatureMimePartBuilder().withSignature(as2Signature).withCertificate(this.selfCertificate).withAlgorithm(this.as2Digest.getAlgorithm()).withPropagateContentType(this.propagateContentType).withContentTransferEncoding(this.encoding).build();
        this.mimeParts.add(this.signaturePart);
        this.headers.setContentType(String.format("%s; protocol=\"%s\"; micalg=%s", "multipart/signed", "application/pkcs7-signature", this.as2Digest.getAlgorithm().name()));
        LOGGER.trace("Call BuildMimeMultipart");
        return super.build();
    }

    @Override
    protected InputStream composeContent() {
        Vector<InputStream> allTheStreams = new Vector<InputStream>();
        allTheStreams.add(new ByteArrayInputStream(this.boundary.getBytes()));
        allTheStreams.add(this.as2Digest.getDigestingInputStream());
        allTheStreams.add(new ByteArrayInputStream(this.boundary.getBytes()));
        allTheStreams.add(new MimePartInputStream(this.signaturePart));
        allTheStreams.add(new ByteArrayInputStream(this.boundaryEnd.getBytes()));
        return new SequenceInputStream(allTheStreams.elements());
    }

    private void validateReadyToBuild() {
        if (this.mimeParts.size() != 1) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with 1 and only 1 MimePart to sign before building");
        }
        if (this.privateKey == null) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with a PrivateKey before building", AS2ErrorType.CONFIGURATION);
        }
        if (this.selfCertificate == null) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with a Certificate before building", AS2ErrorType.CONFIGURATION);
        }
        try {
            ((X509Certificate)this.selfCertificate).checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new AS2ExtensionException("The certificate is expired. The SignedMimeMultipartBuilder must be initialised with a valid Certificate before building.", AS2ErrorType.CONFIGURATION);
        }
        catch (CertificateNotYetValidException e) {
            throw new AS2ExtensionException("The certificate is not valid yet. The SignedMimeMultipartBuilder must be initialised with a valid Certificate before building", AS2ErrorType.CONFIGURATION);
        }
        if (this.as2Digest == null) {
            throw new AS2ExtensionException("SignedMimeMultipartBuilder must be initialised with a Digest before building");
        }
    }
}

