/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.receive;

import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MDNBuilder;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandler;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.ReceivedMessageInfo;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import com.mulesoft.connector.as2.internal.receive.SignedMimeMessageAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveSyncMDNHandler
extends ReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveSyncMDNHandler.class);

    @Override
    protected void notifyResultMDN(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, boolean processed, MimePart receivedMimePart) {
        LOGGER.debug("Building MDN. Information is required");
        AS2MDNBuilder mdnBuilder = new AS2MDNBuilder().withRequestKeyStore(requestKeyStore).withBoundaryIdentifierGeneratorFactory(this.getBoundaryIdentifierGeneratorFactory()).withReceiveMessageInfo(messageInfo).withDispositionType(dispositionType).withProcessed(processed).withHeaders(true).withReceiptDeliveryOption(this.shouldAddReceiptDeliveryOption());
        callback.notifySyncMDNResult(messageInfo.getContent(), signedMimeMessageAttributes, dispositionType, receivedMimePart, mdnBuilder);
    }

    @Override
    protected boolean shouldAddReceiptDeliveryOption() {
        LOGGER.debug("MDN is Sync so ReceiptDeliveryOption will not be added.");
        return false;
    }
}

