/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.enums;

import java.util.stream.Stream;

public enum AS2Compression {
    NONE("none"),
    ZLIB("zlib");

    private String canonicalName;

    private AS2Compression(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public static AS2Compression findByCanonicalName(String canonicalName) {
        return Stream.of(AS2Compression.values()).filter(as2Compression -> AS2Compression.matches(canonicalName, as2Compression)).findFirst().orElse(null);
    }

    private static boolean matches(String canonicalName, AS2Compression as2Compression) {
        return as2Compression.canonicalName.equalsIgnoreCase(canonicalName) || as2Compression.name().equalsIgnoreCase(canonicalName);
    }
}

