/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.codec.CodecInputStream;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.utils.AS2BouncyCastleProvider;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.Iterator;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedMimeParser
implements MimeContentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedMimeParser.class);
    private static final String ENVELOPED_DATA = "enveloped-data";
    private static final String UNABLE_TO_DECRYPT_THE_MESSAGE = "Unable to decrypt the message";
    public static final String APPLICATION_PKCS7_MIME = "application/pkcs7-mime";
    private PrivateKey privateKey;

    public EncryptedMimeParser withPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Override
    public boolean canParseContentType(String contentType) {
        LOGGER.trace(String.format("Parsing Encripted ContentType with value %s", contentType));
        if (contentType == null) {
            LOGGER.debug("Parsing Encrypted ContentType is not possible");
            return false;
        }
        LOGGER.trace("Finding enveloped data value.");
        String sMimeType = AS2PatternMatchers.findSMimeTypeFrom(contentType);
        if (contentType.toLowerCase().startsWith(APPLICATION_PKCS7_MIME) && sMimeType != null) {
            LOGGER.debug(String.format("Returning enveloped data value: %s", sMimeType));
            return sMimeType.equalsIgnoreCase(ENVELOPED_DATA);
        }
        LOGGER.trace("Finding enveloped data value.");
        return false;
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    public MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) {
        LOGGER.trace("Parsing encrypted MIME part.");
        is = this.getDecodedInputStream(mimeHeaders, is);
        try {
            CMSEnvelopedDataParser envelopedDataParser = new CMSEnvelopedDataParser(is);
            Iterator recipientIterator = envelopedDataParser.getRecipientInfos().getRecipients().iterator();
            if (recipientIterator.hasNext()) {
                RecipientInformation recipient = (RecipientInformation)recipientIterator.next();
                CMSTypedStream recData = recipient.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(this.privateKey).setProvider((Provider)AS2BouncyCastleProvider.getBouncyCastleProvider()));
                InputStream contentStream = recData.getContentStream();
                MimePart underlyingMimePart = mimeParserController.parse(contentStream);
                LOGGER.trace("Finished parsing encrypted MIME part");
                return underlyingMimePart;
            }
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_DECRYPTION_FAILED, "Unable to decrypt the message - no recipients", AS2ErrorType.DECRYPTION);
        }
        catch (IOException | CMSException e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_DECRYPTION_FAILED, UNABLE_TO_DECRYPT_THE_MESSAGE, AS2ErrorType.DECRYPTION, e);
        }
    }

    private InputStream getDecodedInputStream(MimeHeaders mimeHeaders, InputStream is) {
        if (mimeHeaders.get("Content-Transfer-Encoding") != null && (EncodingType.findByCanonicalName((String)mimeHeaders.get("Content-Transfer-Encoding")).equals((Object)EncodingType.BASE64) || EncodingType.findByCanonicalName((String)mimeHeaders.get("Content-Transfer-Encoding")).equals((Object)EncodingType.QUOTED_PRINTABLE))) {
            return CodecInputStream.builder(is, true).withEncoding(mimeHeaders.getContentTransferEncoding()).build();
        }
        return is;
    }
}

