/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.receive;

import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MDNBuilder;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandler;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.ReceivedMessageInfo;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import com.mulesoft.connector.as2.internal.receive.SignedMimeMessageAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveNoMDNHandler
extends ReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveNoMDNHandler.class);

    @Override
    protected void notifyResultMDN(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, boolean processed, MimePart receivedMimePart) {
        LOGGER.debug("Building empty MDN. Information is not required");
        callback.notifyNoMDNResult(messageInfo.getContent(), signedMimeMessageAttributes, receivedMimePart, new AS2MDNBuilder());
    }

    @Override
    protected void doErrorMdnResponse(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, DispositionType errorDisposition, MimePart receivedMimePart, Throwable exception) {
        LOGGER.debug("MDN is NOT required into doErrorMdnResponse");
        this.closeContentStream(messageInfo);
        callback.notifyError(exception, receivedMimePart);
    }

    @Override
    protected boolean shouldAddReceiptDeliveryOption() {
        LOGGER.debug("There is no MDN so ReceiptDeliveryOption will not be added.");
        return false;
    }
}

