/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.crypto.DigestingInputStream;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.CompressionMimeParser;
import com.mulesoft.connector.as2.internal.mime.parse.MDNReportParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeHeaderDeserializer;
import com.mulesoft.connector.as2.internal.mime.parse.MimeMultipartContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.PKCS7SignatureContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.SignedMimeMultipartParser;
import com.mulesoft.connector.as2.internal.mime.parse.SimpleMimeContentParser;
import com.mulesoft.connector.as2.internal.stream.CRLFNormalisingInputStream;
import com.mulesoft.connector.as2.internal.stream.ReplayInputStream;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeParserController {
    private static Logger LOGGER = LoggerFactory.getLogger(MimeParserController.class);
    private List<MimeContentParser> contentParsers = new ArrayList<MimeContentParser>();
    private MimeHeaderDeserializer mimeHeaderDeserializer = new MimeHeaderDeserializer();
    private Map<String, String> httpHeaders;
    private boolean isMdn;

    public MimeParserController(boolean isNonRepudiationEnabled, boolean isMdn) {
        this.isMdn = isMdn;
        this.contentParsers.add(new PKCS7SignatureContentParser());
        this.contentParsers.add(new SignedMimeMultipartParser(isNonRepudiationEnabled));
        this.contentParsers.add(new MimeMultipartContentParser());
        this.contentParsers.add(new MDNReportParser());
        this.contentParsers.add(new CompressionMimeParser());
    }

    public MimeParserController(boolean isNonRepudiationEnabled) {
        this(isNonRepudiationEnabled, false);
    }

    public MimeParserController withContentParser(MimeContentParser mimeContentParser) {
        this.contentParsers.add(mimeContentParser);
        return this;
    }

    public MimeParserController withContentParser(int index, MimeContentParser mimeContentParser) {
        this.contentParsers.add(index, mimeContentParser);
        return this;
    }

    public MimePart parse(Map<String, String> httpHeaders, InputStream inputStream) throws IOException {
        LOGGER.info("MimeParserController.parse(headers,is)");
        InputStream is = this.isMdn ? new CRLFNormalisingInputStream(inputStream) : inputStream;
        this.httpHeaders = httpHeaders;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MimeParserController.parse:");
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                LOGGER.debug("{} : {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        MimeHeaders headers = this.mimeHeaderDeserializer.fromHttpHeaders(httpHeaders);
        MimeContentParser contentParser = this.findContentParserForContentType(headers.getContentType());
        HashAlgorithm hashAlgorithm = this.getHashAlgorithm();
        if (contentParser.digestRequired() && hashAlgorithm != HashAlgorithm.UNSIGNED) {
            LOGGER.trace("MimeParserController.parse(map, is): parseMimePartWithDigest");
            return this.parseMimePartWithDigest(contentParser, headers, hashAlgorithm, is, false);
        }
        return contentParser.parse(headers, is, this);
    }

    public MimePart parse(InputStream is) throws IOException {
        LOGGER.trace("MimeParserController.parse(is)");
        ReplayInputStream replayInputStream = new ReplayInputStream(new CRLFNormalisingInputStream(is));
        MimeHeaders headers = this.mimeHeaderDeserializer.deserializeEntityHeaders(replayInputStream);
        MimeContentParser contentParser = this.findContentParserForContentType(headers.getContentType());
        HashAlgorithm hashAlgorithm = this.getHashAlgorithm();
        if (contentParser.digestRequired() && hashAlgorithm != HashAlgorithm.UNSIGNED) {
            LOGGER.trace("PMimeParserController.parse(is): parseMimePartWithDigest");
            return this.parseMimePartWithDigest(contentParser, headers, hashAlgorithm, new SequenceInputStream(new ByteArrayInputStream(replayInputStream.replay()), is), true);
        }
        return contentParser.parse(headers, is, this);
    }

    private MimePart parseMimePartWithDigest(MimeContentParser contentParser, MimeHeaders headers, HashAlgorithm hashAlgorithm, InputStream is, boolean readHeaders) throws IOException {
        AS2Digest as2Digest = new AS2Digest().withAlgorithm(hashAlgorithm).withContent(is).initialise();
        DigestingInputStream digestingInputStream = as2Digest.getDigestingInputStream();
        if (readHeaders) {
            this.mimeHeaderDeserializer.deserializeEntityHeaders(digestingInputStream);
        }
        Object mimePart = contentParser.parse(headers, digestingInputStream, this);
        ((MimePart)mimePart).setAs2Digest(as2Digest);
        return mimePart;
    }

    private HashAlgorithm getHashAlgorithm() {
        if (this.httpHeaders == null) {
            return HashAlgorithm.UNSIGNED;
        }
        String dispositionNotificationOptions = this.httpHeaders.get("Disposition-Notification-Options");
        if (dispositionNotificationOptions == null) {
            LOGGER.debug("HashAlgorithm is Unsigned.");
            return HashAlgorithm.UNSIGNED;
        }
        return AS2PatternMatchers.findMicAlgorithmFrom(dispositionNotificationOptions);
    }

    private MimeContentParser findContentParserForContentType(String contentType) {
        for (MimeContentParser contentParser : this.contentParsers) {
            if (!contentParser.canParseContentType(contentType)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MimeContentParser {} found for content type {}", contentParser.getClass(), (Object)contentType);
            }
            return contentParser;
        }
        LOGGER.debug("Returning SimpleMimeContentParser for content type {}", (Object)contentType);
        return new SimpleMimeContentParser();
    }
}

