/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.MDNReportMultiPartBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.SignedMimeMultipartBuilder;
import com.mulesoft.connector.as2.internal.receive.MDN;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandler;
import com.mulesoft.connector.as2.internal.receive.ReceivedMessageInfo;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import java.time.ZonedDateTime;
import java.util.Base64;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2MDNBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveHandler.class);
    private RequestKeyStore requestKeyStore;
    private ReceivedMessageInfo messageInfo;
    private BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();
    private AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory = new AS2MessageIdGeneratorFactory();
    private DispositionType dispositionType = DispositionType.PROCESSED;
    private byte[] originalMsgAS2DigestHash = null;
    private Boolean processed = false;
    private Boolean useHeaders = false;
    private Boolean useReceiptDeliveryOption = false;
    private boolean includeSourceId;
    private boolean includeServerInfo;

    public static AS2MDNBuilder defaultAS2MDNBuilder() {
        return new AS2MDNBuilder(true, true);
    }

    public AS2MDNBuilder(boolean includeSourceId, boolean includeServerInfo) {
        this.includeServerInfo = includeServerInfo;
        this.includeSourceId = includeSourceId;
    }

    public AS2MDNBuilder withRequestKeyStore(RequestKeyStore requestKeyStore) {
        this.requestKeyStore = requestKeyStore;
        return this;
    }

    public AS2MDNBuilder withReceiveMessageInfo(ReceivedMessageInfo messageInfo) {
        this.messageInfo = messageInfo;
        return this;
    }

    public AS2MDNBuilder withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public AS2MDNBuilder withAS2MessageIdGeneratorFactory(AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory) {
        this.as2MessageIdGeneratorFactory = as2MessageIdGeneratorFactory;
        return this;
    }

    public AS2MDNBuilder withDispositionType(DispositionType dispositionType) {
        this.dispositionType = dispositionType;
        return this;
    }

    public AS2MDNBuilder withOriginalMsgAS2DigestHash(byte[] originalMsgAS2DigestHash) {
        this.originalMsgAS2DigestHash = originalMsgAS2DigestHash;
        return this;
    }

    public AS2MDNBuilder withProcessed(Boolean processed) {
        this.processed = processed;
        return this;
    }

    public AS2MDNBuilder withHeaders(Boolean useHeaders) {
        this.useHeaders = useHeaders;
        return this;
    }

    public AS2MDNBuilder withReceiptDeliveryOption(Boolean useReceiptDeliveryOption) {
        this.useReceiptDeliveryOption = useReceiptDeliveryOption;
        return this;
    }

    public MDN buildEmpty() {
        MDN mdn = new MDN();
        mdn.setProcessed(false);
        return mdn;
    }

    public MDN build() {
        if (this.messageInfo.getAs2Digest() == null) {
            LOGGER.trace("Starting building MDN withOut Original AS2 DigestHash");
        } else {
            this.originalMsgAS2DigestHash = this.messageInfo.getAs2Digest().getHash();
            LOGGER.trace("Starting building MDN with Original AS2 DigestHash");
        }
        LOGGER.trace("ReceiveHandler - Building MDN...");
        MDN mdn = new MDN();
        String recipient = (String)this.messageInfo.getHttpHeaders().get((Object)"AS2-To");
        HashAlgorithm originalMicAlg = null;
        if (this.messageInfo.getAs2Digest() != null) {
            originalMicAlg = this.messageInfo.getAs2Digest().getAlgorithm();
            LOGGER.debug(String.format("The original MicAlg from AS2 Digest: %s", originalMicAlg.algorithm()));
        }
        if (this.originalMsgAS2DigestHash != null) {
            mdn.setOriginalMicAlgorithm(originalMicAlg);
            mdn.setOriginalMic(new String(Base64.getEncoder().encode(this.originalMsgAS2DigestHash)));
            mdn.setOriginalMessageId((String)this.messageInfo.getHttpHeaders().get((Object)"Message-ID"));
        }
        MimePart multipartReport = new MDNReportMultiPartBuilder().withFileName(this.messageInfo.getFileName()).withOriginalMessageId((String)this.messageInfo.getHttpHeaders().get((Object)"Message-ID")).withFromPartnerName((String)this.messageInfo.getHttpHeaders().get((Object)"AS2-From")).withOriginalRecipient(recipient).withFinalRecipient(recipient).withReceiveDate(ZonedDateTime.now()).withDispositionType(this.dispositionType).withOriginalMic(this.originalMsgAS2DigestHash).withOriginalMicAlg(originalMicAlg).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
        if (this.isSignedMDN(this.requestKeyStore, this.messageInfo)) {
            HashAlgorithm mdnSigningHashAlgorithm = HashAlgorithm.SHA1;
            if (this.messageInfo.getMdnSigningAlgorithm() != null) {
                mdnSigningHashAlgorithm = HashAlgorithm.findByAlgorithm(this.messageInfo.getMdnSigningAlgorithm().algorithm());
            } else {
                LOGGER.warn("An algorithm for signing the response mdn was not found on the original received message, using SHA1 by default.");
            }
            mdn.setHashAlgorithm(mdnSigningHashAlgorithm);
            LOGGER.debug(String.format("Initializing AS2Digest with algorithm %s", new Object[]{mdnSigningHashAlgorithm}));
            AS2Digest as2Digest = new AS2Digest().withContent(new MimePartInputStream(multipartReport)).withAlgorithm(mdnSigningHashAlgorithm).initialise();
            MimePart signedMultipartReport = new SignedMimeMultipartBuilder().withPrivateKey(this.requestKeyStore.getSelfPrivateKeyForMDN()).withSelfCertificate(this.requestKeyStore.getSelfCertificateForMDN()).withDigest(as2Digest).withMimePart(multipartReport).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
            mdn.setMdnMimePart(signedMultipartReport);
            mdn.setProcessed(this.processed);
            if (this.useHeaders.booleanValue()) {
                mdn.setMdnHttpHeaders(this.generateMDNHeaders(this.messageInfo.getHttpHeaders(), mdn.getMdnMimePart().getHeaders()));
            }
            return mdn;
        }
        mdn.setMdnMimePart(multipartReport);
        mdn.setProcessed(this.processed);
        if (this.useHeaders.booleanValue()) {
            mdn.setMdnHttpHeaders(this.generateMDNHeaders(this.messageInfo.getHttpHeaders(), mdn.getMdnMimePart().getHeaders()));
        }
        return mdn;
    }

    private boolean isSignedMDN(RequestKeyStore requestKeyStore, ReceivedMessageInfo messageInfo) {
        return requestKeyStore.getSelfCertificate() != null && requestKeyStore.getSelfPrivateKey() != null && messageInfo.getMdnSigningAlgorithm() != HashAlgorithm.UNSIGNED;
    }

    private MultiMap<String, String> generateMDNHeaders(CaseInsensitiveMultiMap httpHeaders, MimeHeaders mimeHeaders) {
        MultiMap mdnHeaders = new MultiMap();
        mimeHeaders.forEach((arg_0, arg_1) -> ((MultiMap)mdnHeaders).put(arg_0, arg_1));
        LOGGER.trace("Generating MDN Headers...");
        mdnHeaders.put((Object)"Mime-Version", (Object)"1.0");
        mdnHeaders.put((Object)"AS2-Version", (Object)"1.1");
        String as2To = this.getMdnAs2FromHeader(httpHeaders, (MultiMap<String, String>)mdnHeaders);
        String as2From = this.getMdnAs2ToHeader(httpHeaders, (MultiMap<String, String>)mdnHeaders);
        StringBuilder subjectBuilder = new StringBuilder();
        subjectBuilder.append("MDN Response");
        if (this.includeSourceId) {
            subjectBuilder.append(" for ");
            subjectBuilder.append((String)httpHeaders.get((Object)"Message-ID"));
        }
        String newMessageID = this.getAs2MessageIdGeneratorFactory().getInstance(this.includeServerInfo).generateMessageId(as2To, as2From);
        mdnHeaders.put((Object)"Message-ID", (Object)newMessageID);
        mdnHeaders.put((Object)"Subject", (Object)subjectBuilder.toString());
        if (this.useReceiptDeliveryOption.booleanValue()) {
            this.addReceiptDeliveryOption(httpHeaders, (MultiMap<String, String>)mdnHeaders);
        }
        return mdnHeaders;
    }

    private String getMdnAs2FromHeader(CaseInsensitiveMultiMap httpHeaders, MultiMap<String, String> mdnHeaders) {
        String as2To = (String)httpHeaders.get((Object)"AS2-To");
        mdnHeaders.put((Object)"AS2-From", (Object)as2To);
        return this.clearDoubleQuotes(as2To);
    }

    private String getMdnAs2ToHeader(CaseInsensitiveMultiMap httpHeaders, MultiMap<String, String> mdnHeaders) {
        String as2From = (String)httpHeaders.get((Object)"AS2-From");
        mdnHeaders.put((Object)"AS2-To", (Object)as2From);
        return this.clearDoubleQuotes(as2From);
    }

    private String clearDoubleQuotes(String value) {
        return value != null && value.length() > 0 ? value.replace("\"", "") : value;
    }

    private AS2MessageIdGeneratorFactory getAs2MessageIdGeneratorFactory() {
        return this.as2MessageIdGeneratorFactory;
    }

    private void addReceiptDeliveryOption(CaseInsensitiveMultiMap httpHeaders, MultiMap<String, String> mdnHeaders) {
        LOGGER.debug("MDN is Async so ReceiptDeliveryOption will be added.");
        LOGGER.debug("Checking recipient address for Async MDN");
        String receiptDeliveryOption = (String)httpHeaders.get((Object)"Receipt-Delivery-Option");
        if (!this.receiptDeliveryOptionMustStartWithHttp(receiptDeliveryOption)) {
            String errorMessage = "The Recipient-Address %s obtained from Receipt-Delivery-Option was invalid as it did not start with http";
            throw new AS2ExtensionException(String.format(errorMessage, receiptDeliveryOption), AS2ErrorType.MIME_PARSE);
        }
        mdnHeaders.put((Object)"Recipient-Address", (Object)receiptDeliveryOption);
        LOGGER.debug(String.format("The Async MDN recipient address is %s", receiptDeliveryOption));
    }

    private boolean receiptDeliveryOptionMustStartWithHttp(String receiptDeliveryOption) {
        return receiptDeliveryOption.toLowerCase().startsWith("http");
    }
}

