/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.crypto.hpke;

import org.bouncycastle.shaded.crypto.InvalidCipherTextException;
import org.bouncycastle.shaded.crypto.hpke.AEAD;
import org.bouncycastle.shaded.crypto.hpke.HKDF;

public class HPKEContext {
    protected final AEAD aead;
    protected final HKDF hkdf;
    protected final byte[] exporterSecret;
    protected final byte[] suiteId;

    HPKEContext(AEAD aEAD, HKDF hKDF, byte[] byArray, byte[] byArray2) {
        this.aead = aEAD;
        this.hkdf = hKDF;
        this.exporterSecret = byArray;
        this.suiteId = byArray2;
    }

    public byte[] export(byte[] byArray, int n) {
        return this.hkdf.LabeledExpand(this.exporterSecret, this.suiteId, "sec", byArray, n);
    }

    public byte[] seal(byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        return this.aead.seal(byArray, byArray2);
    }

    public byte[] open(byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        return this.aead.open(byArray, byArray2);
    }
}

