/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.mime.smime;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.shaded.mime.BasicMimeParser;
import org.bouncycastle.shaded.mime.Headers;
import org.bouncycastle.shaded.mime.MimeParser;
import org.bouncycastle.shaded.mime.MimeParserProvider;
import org.bouncycastle.shaded.mime.smime.SMimeParserContext;
import org.bouncycastle.shaded.mime.smime.SMimeUtils;
import org.bouncycastle.shaded.operator.DigestCalculatorProvider;

public class SMimeParserProvider
implements MimeParserProvider {
    private final String defaultContentTransferEncoding;
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMimeParserProvider(String string, DigestCalculatorProvider digestCalculatorProvider) {
        this.defaultContentTransferEncoding = string;
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    @Override
    public MimeParser createParser(InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), SMimeUtils.autoBuffer(inputStream));
    }

    @Override
    public MimeParser createParser(Headers headers, InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), headers, SMimeUtils.autoBuffer(inputStream));
    }
}

