/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.cmp;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.shaded.asn1.ASN1EncodableVector;
import org.bouncycastle.shaded.asn1.ASN1Integer;
import org.bouncycastle.shaded.asn1.DERSequence;
import org.bouncycastle.shaded.asn1.cmp.CMPCertificate;
import org.bouncycastle.shaded.asn1.cmp.CertConfirmContent;
import org.bouncycastle.shaded.asn1.cmp.CertStatus;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cert.cmp.CMPException;
import org.bouncycastle.shaded.cert.cmp.CMPUtil;
import org.bouncycastle.shaded.cert.cmp.CertificateConfirmationContent;
import org.bouncycastle.shaded.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.shaded.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.shaded.operator.DigestCalculator;
import org.bouncycastle.shaded.operator.DigestCalculatorProvider;
import org.bouncycastle.shaded.operator.OperatorCreationException;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private List<CMPCertificate> acceptedCerts = new ArrayList<CMPCertificate>();
    private List<AlgorithmIdentifier> acceptedSignatureAlgorithms = new ArrayList<AlgorithmIdentifier>();
    private List<ASN1Integer> acceptedReqIds = new ArrayList<ASN1Integer>();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder x509CertificateHolder, BigInteger bigInteger) {
        return this.addAcceptedCertificate(x509CertificateHolder, new ASN1Integer(bigInteger));
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder x509CertificateHolder, ASN1Integer aSN1Integer) {
        return this.addAcceptedCertificate(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), aSN1Integer);
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, ASN1Integer aSN1Integer) {
        this.acceptedCerts.add(cMPCertificate);
        this.acceptedSignatureAlgorithms.add(algorithmIdentifier);
        this.acceptedReqIds.add(aSN1Integer);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i != this.acceptedCerts.size(); ++i) {
            DigestCalculator digestCalculator;
            CMPCertificate cMPCertificate = this.acceptedCerts.get(i);
            ASN1Integer aSN1Integer = this.acceptedReqIds.get(i);
            AlgorithmIdentifier algorithmIdentifier = this.digestAlgFinder.find(this.acceptedSignatureAlgorithms.get(i));
            if (algorithmIdentifier == null) {
                throw new CMPException("cannot find algorithm for digest from signature");
            }
            try {
                digestCalculator = digestCalculatorProvider.get(algorithmIdentifier);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMPException("unable to create digest: " + operatorCreationException.getMessage(), operatorCreationException);
            }
            CMPUtil.derEncodeToStream(cMPCertificate, digestCalculator.getOutputStream());
            aSN1EncodableVector.add(new CertStatus(digestCalculator.getDigest(), aSN1Integer));
        }
        return new CertificateConfirmationContent(CertConfirmContent.getInstance(new DERSequence(aSN1EncodableVector)), this.digestAlgFinder);
    }
}

