/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.crypto.Wrapper;
import org.bouncycastle.shaded.crypto.params.KeyParameter;
import org.bouncycastle.shaded.crypto.params.ParametersWithRandom;
import org.bouncycastle.shaded.operator.GenericKey;
import org.bouncycastle.shaded.operator.OperatorException;
import org.bouncycastle.shaded.operator.SymmetricKeyWrapper;
import org.bouncycastle.shaded.operator.bc.OperatorUtils;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(byArray, 0, byArray.length);
    }
}

