/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.PKCS7SignatureBlockBuilder;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.shaded.asn1.ASN1Primitive;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cert.jcajce.JcaCertStore;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.CMSProcessableByteArray;
import org.bouncycastle.shaded.cms.CMSSignedDataGenerator;
import org.bouncycastle.shaded.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.shaded.operator.ContentSigner;
import org.bouncycastle.shaded.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.shaded.operator.OperatorCreationException;
import org.bouncycastle.shaded.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7SignatureBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKCS7SignatureBlock.class);
    private static final String GENERATING_THE_ENCODED_PKCS_7_OBJECT_FAILED = "Generating the encoded PKCS7 object failed";
    private List<Certificate> certificates;
    private List<byte[]> encryptedHashes;
    private List<HashAlgorithm> hashAlgorithms;

    public static PKCS7SignatureBlockBuilder builder() {
        return new PKCS7SignatureBlockBuilder();
    }

    public byte[] asn1EncodedPKCS7() {
        CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
        this.addCertificatesToSignedData(cmsSignedDataGenerator);
        this.addSignerInfoToSignedData(cmsSignedDataGenerator);
        CMSProcessableByteArray msg = new CMSProcessableByteArray(new byte[0]);
        try {
            return cmsSignedDataGenerator.generate(msg, false).getEncoded();
        }
        catch (IOException | CMSException e) {
            LOGGER.error(GENERATING_THE_ENCODED_PKCS_7_OBJECT_FAILED, (Throwable)e);
            throw new AS2ExtensionException(GENERATING_THE_ENCODED_PKCS_7_OBJECT_FAILED, e);
        }
    }

    private void addSignerInfoToSignedData(CMSSignedDataGenerator cmsSignedDataGenerator) {
        Iterator<Certificate> certificateIterator = this.certificates.iterator();
        Iterator<byte[]> encryptedHashIterator = this.encryptedHashes.iterator();
        Iterator<HashAlgorithm> algorithmIterator = this.hashAlgorithms.iterator();
        while (certificateIterator.hasNext() && encryptedHashIterator.hasNext() && algorithmIterator.hasNext()) {
            NonSigner nonSigner = new NonSigner(algorithmIterator.next(), encryptedHashIterator.next());
            try {
                org.bouncycastle.shaded.asn1.x509.Certificate cert = org.bouncycastle.shaded.asn1.x509.Certificate.getInstance(ASN1Primitive.fromByteArray(certificateIterator.next().getEncoded()));
                JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build());
                signerInfoBuilder.setDirectSignature(true);
                cmsSignedDataGenerator.addSignerInfoGenerator(signerInfoBuilder.build((ContentSigner)nonSigner, new X509CertificateHolder(cert)));
            }
            catch (IOException | CertificateEncodingException | OperatorCreationException e) {
                String addingSignerInfoError = "Adding signer info to the PKCS7 object failed";
                LOGGER.error(addingSignerInfoError);
                throw new AS2ExtensionException(addingSignerInfoError, e);
            }
        }
    }

    private void addCertificatesToSignedData(CMSSignedDataGenerator cmsSignedDataGenerator) {
        try {
            JcaCertStore certificateStore = new JcaCertStore(this.certificates);
            cmsSignedDataGenerator.addCertificates(certificateStore);
        }
        catch (CertificateEncodingException | CMSException e) {
            String addingCertificateError = "Adding certificates to the PKCS7 object failed";
            LOGGER.error(addingCertificateError, (Throwable)e);
            throw new AS2ExtensionException(addingCertificateError, e);
        }
    }

    List<Certificate> getCertificates() {
        return this.certificates;
    }

    void setCertificates(List<Certificate> certificates) {
        this.certificates = certificates;
    }

    List<byte[]> getEncryptedHashes() {
        return this.encryptedHashes;
    }

    void setEncryptedHashes(List<byte[]> encryptedHashes) {
        this.encryptedHashes = encryptedHashes;
    }

    List<HashAlgorithm> getHashAlgorithms() {
        return this.hashAlgorithms;
    }

    void setHashAlgorithms(List<HashAlgorithm> hashAlgorithms) {
        this.hashAlgorithms = hashAlgorithms;
    }

    private class NonSigner
    implements ContentSigner {
        private HashAlgorithm hashAlgorithm;
        private byte[] encryptedHash;

        public NonSigner(HashAlgorithm hashAlgorithm, byte[] encryptedHash) {
            this.hashAlgorithm = hashAlgorithm;
            this.encryptedHash = encryptedHash;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new DefaultSignatureAlgorithmIdentifierFinder().find(this.hashAlgorithm.name() + "withRSA");
        }

        @Override
        public OutputStream getOutputStream() {
            return new ByteArrayOutputStream();
        }

        @Override
        public byte[] getSignature() {
            return this.encryptedHash;
        }
    }
}

