/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;

public class ValidCertificate
extends X509Certificate {
    private final X509Certificate certificate;
    final boolean shouldValidate;

    public ValidCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        this.shouldValidate = false;
    }

    public ValidCertificate(X509Certificate certificate, boolean shouldValidate) {
        this.certificate = certificate;
        this.shouldValidate = shouldValidate;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.shouldValidate) {
            this.certificate.checkValidity();
        }
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.shouldValidate) {
            this.certificate.checkValidity(date);
        }
    }

    @Override
    public int getVersion() {
        return this.certificate.getVersion();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    @Override
    public Principal getIssuerDN() {
        return this.certificate.getIssuerDN();
    }

    @Override
    public Principal getSubjectDN() {
        return this.certificate.getSubjectDN();
    }

    @Override
    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    @Override
    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.certificate.getTBSCertificate();
    }

    @Override
    public byte[] getSignature() {
        return this.certificate.getSignature();
    }

    @Override
    public String getSigAlgName() {
        return this.certificate.getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.certificate.getSigAlgParams();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.certificate.getIssuerUniqueID();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.certificate.getSubjectUniqueID();
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.certificate.getKeyUsage();
    }

    @Override
    public int getBasicConstraints() {
        return this.certificate.getBasicConstraints();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.certificate.getEncoded();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.certificate.verify(key);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.certificate.verify(key, sigProvider);
    }

    @Override
    public String toString() {
        return this.certificate.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.certificate.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.certificate.getCriticalExtensionOIDs();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.certificate.getNonCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.certificate.getExtensionValue(oid);
    }
}

