/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.stream;

import java.util.Arrays;

public class Buffer {
    private byte[] buffer;
    private int readDataPos;
    private int loadedDataPos;
    private int increment = 500;

    public Buffer() {
    }

    public Buffer(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
        this.increment = initialCapacity;
    }

    public synchronized boolean hasMoreData() {
        return this.available() > 0;
    }

    public synchronized int available() {
        if (this.buffer == null) {
            return 0;
        }
        return this.loadedDataPos - this.readDataPos;
    }

    public synchronized void load(byte nextByte) {
        if (this.buffer == null || this.loadedDataPos > this.buffer.length - 1) {
            this.increaseCapacity();
        }
        this.buffer[this.loadedDataPos++] = nextByte;
    }

    public synchronized void load(byte[] nextBytes) {
        this.load(nextBytes, 0, nextBytes.length);
    }

    public synchronized void load(byte[] nextBytes, int offset, int length) {
        if (this.buffer == null || this.loadedDataPos > this.buffer.length - length) {
            this.increaseCapacity(length);
        }
        for (int i = offset; i < length + offset; ++i) {
            this.buffer[this.loadedDataPos++] = nextBytes[i];
        }
    }

    public synchronized void reload(byte[] buffer) {
        this.buffer = Arrays.copyOf(buffer, buffer.length);
        this.readDataPos = 0;
        this.loadedDataPos = buffer.length;
    }

    public synchronized int read() {
        if (this.hasMoreData()) {
            return this.buffer[this.readDataPos++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int offset, int length) {
        if (!this.hasMoreData()) {
            return -1;
        }
        if (this.loadedDataPos - this.readDataPos < length) {
            length = this.loadedDataPos - this.readDataPos;
        }
        System.arraycopy(this.buffer, this.readDataPos, b, offset, length);
        this.readDataPos += length;
        return length;
    }

    public synchronized byte[] readAll() {
        if (this.buffer == null) {
            return new byte[0];
        }
        byte[] remainingData = new byte[this.available()];
        System.arraycopy(this.buffer, this.readDataPos, remainingData, 0, this.loadedDataPos - this.readDataPos);
        this.buffer = new byte[this.increment];
        this.readDataPos = 0;
        this.loadedDataPos = 0;
        return remainingData;
    }

    private synchronized void increaseCapacity() {
        this.increaseCapacity(1);
    }

    private synchronized void increaseCapacity(int increaseBy) {
        int newLoadedPos = this.available();
        int newLength = ((this.available() + increaseBy) / this.increment + 1) * this.increment;
        byte[] newBuffer = new byte[newLength];
        if (this.buffer != null) {
            System.arraycopy(this.buffer, this.readDataPos, newBuffer, 0, newLoadedPos);
        }
        this.buffer = newBuffer;
        this.loadedDataPos = newLoadedPos;
        this.readDataPos = 0;
    }
}

