/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.dane;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cert.dane.DANEEntry;
import org.bouncycastle.shaded.cert.dane.DANEEntryFetcherFactory;
import org.bouncycastle.shaded.cert.dane.DANEEntrySelector;
import org.bouncycastle.shaded.cert.dane.DANEEntrySelectorFactory;
import org.bouncycastle.shaded.cert.dane.DANEException;
import org.bouncycastle.shaded.operator.DigestCalculator;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory fetcherFactory;
    private final DANEEntrySelectorFactory selectorFactory;

    public DANECertificateFetcher(DANEEntryFetcherFactory dANEEntryFetcherFactory, DigestCalculator digestCalculator) {
        this.fetcherFactory = dANEEntryFetcherFactory;
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String string) throws DANEException {
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        List list = this.fetcherFactory.build(dANEEntrySelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(list.size());
        for (DANEEntry dANEEntry : list) {
            if (!dANEEntrySelector.match(dANEEntry)) continue;
            arrayList.add(dANEEntry.getCertificate());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

