/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.receive;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Optional;

public class RequestKeyStore {
    private PrivateKey selfPrivateKey = null;
    private PrivateKey selfPrivateKeyForMDN = null;
    private Certificate selfCertificateForMDN = null;
    private Certificate selfCertificate = null;
    private Certificate partnerCertificate = null;
    private final boolean validateCertificateExpiration;

    public RequestKeyStore() {
        this(false);
    }

    public RequestKeyStore(boolean validateCertificateExpiration) {
        this.validateCertificateExpiration = validateCertificateExpiration;
    }

    public PrivateKey getSelfPrivateKey() {
        return this.selfPrivateKey;
    }

    public void setSelfPrivateKey(PrivateKey selfPrivateKey) {
        this.selfPrivateKey = selfPrivateKey;
    }

    public Certificate getSelfCertificate() {
        return this.selfCertificate;
    }

    public void setSelfCertificate(Certificate selfCertificate) {
        this.selfCertificate = selfCertificate;
    }

    public PublicKey getPartnerPublicKey() {
        return Optional.ofNullable(this.partnerCertificate).map(Certificate::getPublicKey).orElse(null);
    }

    public Certificate getPartnerCertificate() {
        return this.partnerCertificate;
    }

    public void setPartnerCertificate(Certificate partnerCertificate) {
        this.partnerCertificate = partnerCertificate;
    }

    public PrivateKey getSelfPrivateKeyForMDN() {
        return this.selfPrivateKeyForMDN;
    }

    public void setSelfPrivateKeyForMDN(PrivateKey selfPrivateKeyForMDN) {
        this.selfPrivateKeyForMDN = selfPrivateKeyForMDN;
    }

    public Certificate getSelfCertificateForMDN() {
        return this.selfCertificateForMDN;
    }

    public void setSelfCertificateForMDN(Certificate selfCertificateForMDN) {
        this.selfCertificateForMDN = selfCertificateForMDN;
    }
}

