/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.send.headers;

import com.mulesoft.connector.as2.internal.send.headers.HeaderValidationRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHeadersSanitizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHeadersSanitizer.class);
    private List<HeaderValidationRule> validationRules = new ArrayList<HeaderValidationRule>();

    public void sanitizeHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            for (HeaderValidationRule rule : this.validationRules) {
                if (rule.isValidHeader(header)) continue;
                LOGGER.warn(rule.getWarningMessage(header));
                headers.remove(header.getKey());
            }
        }
    }

    public void addRule(HeaderValidationRule rule) {
        this.validationRules.add(rule);
    }

    public void addRules(List<HeaderValidationRule> rules) {
        this.validationRules.addAll(rules);
    }
}

