/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.crmf;

import org.bouncycastle.shaded.asn1.ASN1Integer;
import org.bouncycastle.shaded.asn1.DEROctetString;
import org.bouncycastle.shaded.asn1.cmp.CMPCertificate;
import org.bouncycastle.shaded.asn1.cmp.CertOrEncCert;
import org.bouncycastle.shaded.asn1.cmp.CertResponse;
import org.bouncycastle.shaded.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.shaded.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.shaded.asn1.cms.EnvelopedData;
import org.bouncycastle.shaded.asn1.crmf.EncryptedKey;
import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cert.crmf.CertificateResponse;
import org.bouncycastle.shaded.cms.CMSEnvelopedData;

public class CertificateResponseBuilder {
    private CertifiedKeyPair certKeyPair;
    private ASN1Integer certReqId;
    private PKIStatusInfo statusInfo;
    private DEROctetString rspInfo;

    public CertificateResponseBuilder(ASN1Integer aSN1Integer, PKIStatusInfo pKIStatusInfo) {
        this.certReqId = aSN1Integer;
        this.statusInfo = pKIStatusInfo;
    }

    public CertificateResponseBuilder withCertificate(X509CertificateHolder x509CertificateHolder) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(new CMPCertificate(x509CertificateHolder.toASN1Structure())));
        return this;
    }

    public CertificateResponseBuilder withCertificate(CMPCertificate cMPCertificate) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(cMPCertificate));
        return this;
    }

    public CertificateResponseBuilder withCertificate(CMSEnvelopedData cMSEnvelopedData) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(new EncryptedKey(EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent()))));
        return this;
    }

    public CertificateResponseBuilder withResponseInfo(byte[] byArray) {
        if (this.rspInfo != null) {
            throw new IllegalStateException("response info already set");
        }
        this.rspInfo = new DEROctetString(byArray);
        return this;
    }

    public CertificateResponse build() {
        return new CertificateResponse(new CertResponse(this.certReqId, this.statusInfo, this.certKeyPair, this.rspInfo));
    }
}

