/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.enums.EncryptionAlgorithm;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.shaded.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.shaded.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.shaded.cms.CMSAlgorithm;

public class EncryptionAlgorithmMapper {
    private static Map<EncryptionAlgorithm, ASN1ObjectIdentifier> algorithmMap = new HashMap<EncryptionAlgorithm, ASN1ObjectIdentifier>();

    public static ASN1ObjectIdentifier map(EncryptionAlgorithm algorithm) {
        return algorithmMap.get((Object)algorithm);
    }

    static {
        algorithmMap.put(EncryptionAlgorithm.AES128_CBC, CMSAlgorithm.AES128_CBC);
        algorithmMap.put(EncryptionAlgorithm.AES192_CBC, CMSAlgorithm.AES192_CBC);
        algorithmMap.put(EncryptionAlgorithm.AES256_CBC, CMSAlgorithm.AES256_CBC);
        algorithmMap.put(EncryptionAlgorithm.AES128_CCM, CMSAlgorithm.AES128_CCM);
        algorithmMap.put(EncryptionAlgorithm.AES192_CCM, CMSAlgorithm.AES192_CCM);
        algorithmMap.put(EncryptionAlgorithm.AES256_CCM, CMSAlgorithm.AES256_CCM);
        algorithmMap.put(EncryptionAlgorithm.AES128_GCM, CMSAlgorithm.AES128_GCM);
        algorithmMap.put(EncryptionAlgorithm.AES192_GCM, CMSAlgorithm.AES192_GCM);
        algorithmMap.put(EncryptionAlgorithm.AES256_GCM, CMSAlgorithm.AES256_GCM);
        algorithmMap.put(EncryptionAlgorithm.AES256_WRAP, NISTObjectIdentifiers.id_aes256_wrap_pad.intern());
        algorithmMap.put(EncryptionAlgorithm.CAST5, CMSAlgorithm.CAST5_CBC);
        algorithmMap.put(EncryptionAlgorithm.RC2, CMSAlgorithm.RC2_CBC);
        algorithmMap.put(EncryptionAlgorithm.DES, CMSAlgorithm.DES_CBC);
        algorithmMap.put(EncryptionAlgorithm.DES_EDE3, CMSAlgorithm.DES_EDE3_CBC);
    }
}

