/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.send.headers;

import com.mulesoft.connector.as2.internal.send.headers.HeaderValidationRule;
import com.mulesoft.connector.as2.internal.utils.AS2HeaderConstants;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AS2HeadersRule
implements HeaderValidationRule {
    private Set<String> as2Headers = AS2HeaderConstants.getHeadersAsSet();

    @Override
    public boolean isValidHeader(Map.Entry<String, String> header) {
        return !this.getAs2HeadersToLowerCase().contains(header.getKey().toLowerCase());
    }

    @Override
    public String getWarningMessage(Map.Entry<String, String> header) {
        return String.format("The existing header '%s' won't be overridden by the custom one.", header.getKey());
    }

    private Set<String> getAs2HeadersToLowerCase() {
        HashSet<String> lowerCaseHeaders = new HashSet<String>();
        this.as2Headers.forEach(header -> lowerCaseHeaders.add(header.toLowerCase()));
        return lowerCaseHeaders;
    }
}

