/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.crmf.bc;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.shaded.asn1.crmf.EncryptedValue;
import org.bouncycastle.shaded.cert.crmf.CRMFException;
import org.bouncycastle.shaded.cert.crmf.EncryptedValueBuilder;
import org.bouncycastle.shaded.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.shaded.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.shaded.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.shaded.operator.KeyWrapper;
import org.bouncycastle.shaded.operator.OutputEncryptor;

public class BcEncryptedValueBuilder
extends EncryptedValueBuilder {
    public BcEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(AsymmetricKeyParameter asymmetricKeyParameter) throws CRMFException, IOException {
        return this.build(PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter));
    }
}

