/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.bouncycastle.shaded.asn1.cms.ContentInfo;
import org.bouncycastle.shaded.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.shaded.asn1.cms.EncryptedData;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.CMSTypedStream;
import org.bouncycastle.shaded.cms.CMSUtils;
import org.bouncycastle.shaded.operator.InputDecryptor;
import org.bouncycastle.shaded.operator.InputDecryptorProvider;

public class CMSEncryptedData {
    private ContentInfo contentInfo;
    private EncryptedData encryptedData;

    public CMSEncryptedData(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        this.encryptedData = EncryptedData.getInstance(contentInfo.getContent());
    }

    public byte[] getContent(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            return CMSUtils.streamToByteArray(this.getContentStream(inputDecryptorProvider).getContentStream());
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse internal stream: " + iOException.getMessage(), iOException);
        }
    }

    public CMSTypedStream getContentStream(InputDecryptorProvider inputDecryptorProvider) throws CMSException {
        try {
            EncryptedContentInfo encryptedContentInfo = this.encryptedData.getEncryptedContentInfo();
            InputDecryptor inputDecryptor = inputDecryptorProvider.get(encryptedContentInfo.getContentEncryptionAlgorithm());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets());
            return new CMSTypedStream(encryptedContentInfo.getContentType(), inputDecryptor.getInputStream(byteArrayInputStream));
        }
        catch (Exception exception) {
            throw new CMSException("unable to create stream: " + exception.getMessage(), exception);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }
}

