/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.validate;

import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.validate.MimePartValidator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeValidatorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeValidatorController.class);
    private List<MimePartValidator> mimePartValidators = new ArrayList<MimePartValidator>();

    public MimeValidatorController withValidator(MimePartValidator validator) {
        this.mimePartValidators.add(validator);
        return this;
    }

    public void validate(MimePart mimePart) {
        if (mimePart.getHeaders() != null && mimePart.getHeaders().getContentType() != null) {
            for (MimePartValidator validator : this.mimePartValidators) {
                LOGGER.debug(String.format("ContentType to Validate: %s", mimePart.getHeaders().getContentType()));
                if (!validator.canValidate(mimePart.getHeaders().getContentType())) continue;
                validator.validate(mimePart);
            }
        }
        if (mimePart.isMultiPart()) {
            LOGGER.debug("MimePart is MultiPart");
            for (MimePart childMimePart : mimePart.getMimeParts()) {
                LOGGER.debug("Validating childMimePart.");
                this.validate(childMimePart);
            }
        }
    }

    public List<MimePartValidator> getMimePartValidators() {
        return this.mimePartValidators;
    }
}

