/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.crmf;

import java.util.Collection;
import org.bouncycastle.shaded.asn1.cmp.CMPCertificate;
import org.bouncycastle.shaded.asn1.cmp.CertResponse;
import org.bouncycastle.shaded.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.shaded.asn1.cms.ContentInfo;
import org.bouncycastle.shaded.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.shaded.cms.CMSEnvelopedData;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.Recipient;
import org.bouncycastle.shaded.cms.RecipientInformation;
import org.bouncycastle.shaded.cms.RecipientInformationStore;

public class CertificateResponse {
    private final CertResponse certResponse;

    public CertificateResponse(CertResponse certResponse) {
        this.certResponse = certResponse;
    }

    public boolean hasEncryptedCertificate() {
        return this.certResponse.getCertifiedKeyPair().getCertOrEncCert().hasEncryptedCertificate();
    }

    public CMSEnvelopedData getEncryptedCertificate() throws CMSException {
        if (!this.hasEncryptedCertificate()) {
            throw new IllegalStateException("encrypted certificate asked for, none found");
        }
        CertifiedKeyPair certifiedKeyPair = this.certResponse.getCertifiedKeyPair();
        CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(new ContentInfo(PKCSObjectIdentifiers.envelopedData, certifiedKeyPair.getCertOrEncCert().getEncryptedCert().getValue()));
        if (cMSEnvelopedData.getRecipientInfos().size() != 1) {
            throw new IllegalStateException("data encrypted for more than one recipient");
        }
        return cMSEnvelopedData;
    }

    public CMPCertificate getCertificate(Recipient recipient) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.getEncryptedCertificate();
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        Collection<RecipientInformation> collection = recipientInformationStore.getRecipients();
        RecipientInformation recipientInformation = collection.iterator().next();
        return CMPCertificate.getInstance(recipientInformation.getContent(recipient));
    }

    public CMPCertificate getCertificate() throws CMSException {
        if (this.hasEncryptedCertificate()) {
            throw new IllegalStateException("plaintext certificate asked for, none found");
        }
        return this.certResponse.getCertifiedKeyPair().getCertOrEncCert().getCertificate();
    }

    public CertResponse toASN1Structure() {
        return this.certResponse;
    }
}

