/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms.bc;

import java.io.InputStream;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.RecipientOperator;
import org.bouncycastle.shaded.cms.bc.BcPasswordRecipient;
import org.bouncycastle.shaded.cms.bc.EnvelopedDataHelper;
import org.bouncycastle.shaded.crypto.BufferedBlockCipher;
import org.bouncycastle.shaded.crypto.StreamCipher;
import org.bouncycastle.shaded.crypto.io.CipherInputStream;
import org.bouncycastle.shaded.crypto.params.KeyParameter;
import org.bouncycastle.shaded.operator.InputDecryptor;

public class BcPasswordEnvelopedRecipient
extends BcPasswordRecipient {
    public BcPasswordEnvelopedRecipient(char[] cArray) {
        super(cArray);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws CMSException {
        KeyParameter keyParameter = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray, byArray2);
        final Object object = EnvelopedDataHelper.createContentCipher(false, keyParameter, algorithmIdentifier2);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                if (object instanceof BufferedBlockCipher) {
                    return new CipherInputStream(inputStream, (BufferedBlockCipher)object);
                }
                return new CipherInputStream(inputStream, (StreamCipher)object);
            }
        });
    }
}

