/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.crypto;

import com.mulesoft.connector.as2.internal.crypto.EncryptionAlgorithmMapper;
import com.mulesoft.connector.as2.internal.enums.EncryptionAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.error.exception.FipsComplianceException;
import com.mulesoft.connector.as2.internal.stream.OutputTransformationInputStream;
import com.mulesoft.connector.as2.internal.utils.AS2BouncyCastleProvider;
import com.mulesoft.connector.as2.internal.utils.AS2FipsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.crypto.spec.OAEPParameterSpec;
import org.bouncycastle.shaded.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.shaded.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.shaded.operator.OutputEncryptor;
import org.bouncycastle.shaded.operator.jcajce.JcaAlgorithmParametersConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7EncryptedEnvelopeStreamBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKCS7EncryptedEnvelopeStreamBuilder.class);
    private X509Certificate certificate;
    private EncryptionAlgorithm encryptionAlgorithm;
    private InputStream content;
    private boolean forceOEAP = AS2FipsUtil.isOEAPForced();
    private boolean forceAlgorithmFipsValidation = false;

    public PKCS7EncryptedEnvelopeStreamBuilder withCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder forceOEAP() {
        this.forceOEAP = true;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder forceAlgorithmFipsValidation() {
        this.forceAlgorithmFipsValidation = true;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder withContent(InputStream content) {
        this.content = content;
        return this;
    }

    public InputStream build() {
        try {
            JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator;
            AS2FipsUtil.validateAlgorithm(this.encryptionAlgorithm, this.forceAlgorithmFipsValidation);
            if (AS2FipsUtil.isFipsMode() || this.forceOEAP) {
                JcaAlgorithmParametersConverter paramsConverter = new JcaAlgorithmParametersConverter();
                AlgorithmIdentifier algorithmIdentifier = paramsConverter.getAlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, OAEPParameterSpec.DEFAULT);
                jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(this.certificate, algorithmIdentifier);
            } else {
                jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(this.certificate);
            }
            CMSEnvelopedDataStreamGenerator cmsEnvelopedDataGenerator = new CMSEnvelopedDataStreamGenerator();
            cmsEnvelopedDataGenerator.addRecipientInfoGenerator(jceKeyTransRecipientInfoGenerator);
            JceCMSContentEncryptorBuilder encryptorBuilder = new JceCMSContentEncryptorBuilder(EncryptionAlgorithmMapper.map(this.encryptionAlgorithm)).setProvider(AS2BouncyCastleProvider.getBouncyCastleProvider());
            OutputEncryptor encryptor = encryptorBuilder.build();
            return new OutputTransformationInputStream(this.content, out -> {
                try {
                    return cmsEnvelopedDataGenerator.open(out, encryptor);
                }
                catch (CMSException e) {
                    LOGGER.debug("CMSException while trying to open cmsEnvelopedDataGenerator", (Throwable)e);
                    throw new IOException(e);
                }
            });
        }
        catch (FipsComplianceException | IOException | InvalidAlgorithmParameterException | CertificateEncodingException | CMSException e) {
            String errorMessage = "Error encrypting content with algorithm " + this.encryptionAlgorithm.name();
            LOGGER.error(errorMessage, (Throwable)e);
            throw new AS2ExtensionException(errorMessage, e);
        }
    }
}

