/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.enums;

import com.mulesoft.connector.as2.internal.enums.FipsValidableAlgorithm;

public enum HashAlgorithm implements FipsValidableAlgorithm
{
    MD5("MD5", HashAlgorithm.getFipsBehavior("MD5", false)),
    SHA1("SHA-1", HashAlgorithm.getFipsBehavior("SHA-1", true)),
    SHA224("SHA-224", HashAlgorithm.getFipsBehavior("SHA-224", true)),
    SHA256("SHA-256", HashAlgorithm.getFipsBehavior("SHA-256", true)),
    SHA384("SHA-384", HashAlgorithm.getFipsBehavior("SHA-384", true)),
    SHA512("SHA-512", HashAlgorithm.getFipsBehavior("SHA-512", true)),
    UNSIGNED("UNSIGNED", HashAlgorithm.getFipsBehavior("UNSIGNED", true));

    private final String algorithm;
    private static final String FORCE_ALG_FIPS_BEHAVIOR_PROP = "mule.as2.is_%s_fips_compliant";
    private boolean isFipsCompliant;

    private HashAlgorithm(String algorithm, boolean isFipsCompliant) {
        this.algorithm = algorithm;
        this.isFipsCompliant = isFipsCompliant;
    }

    public static HashAlgorithm findByAlgorithm(String algorithm) {
        for (HashAlgorithm hashAlgorithm : HashAlgorithm.values()) {
            if (!hashAlgorithm.algorithm.equalsIgnoreCase(algorithm) && !hashAlgorithm.name().equalsIgnoreCase(algorithm)) continue;
            return hashAlgorithm;
        }
        return null;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public String getAlgorithmForheader() {
        return this.algorithm().toLowerCase();
    }

    @Override
    public boolean isFipsCompliant() {
        return this.isFipsCompliant;
    }

    @Override
    public String getName() {
        return this.name();
    }

    private static boolean getFipsBehavior(String algorithm, boolean defaultBehavior) {
        return defaultBehavior;
    }
}

