/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.builder;

import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGenerator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

public class RandomUuidMessageIdGenerator
implements AS2MessageIdGenerator {
    private static final String DATE_TIME_FORMAT = "yyyyMMddHHmmss";
    private boolean appendAs2ServersInfo;

    public RandomUuidMessageIdGenerator(boolean appendAs2ServersInfo) {
        this.appendAs2ServersInfo = appendAs2ServersInfo;
    }

    @Override
    public String generateMessageId(String sender, String receiver) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT);
        String domainId = this.appendAs2ServersInfo ? sender.replace(' ', '_') + "_" + receiver.replace(' ', '_') : "MULESOFT";
        return String.format("<%s-%s@%s>", now.format(formatter), UUID.randomUUID().toString(), domainId);
    }
}

