/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeBoundaryAwareInputStream;
import com.mulesoft.connector.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMultipartContentParser
implements MimeContentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeMultipartContentParser.class);
    private static final String CRLF = "\r\n";
    private static final String BOUNDARY_PREFIX = "\r\n--";
    private static final String BOUNDARY_SUFFIX = "--\r\n";

    @Override
    public boolean canParseContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    public MimePart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) throws IOException {
        MimeBoundaryAwareInputStream inputStream;
        LOGGER.trace("Parsing MIME Multipart");
        MimePart mimePart = new MimePart();
        mimePart.setHeaders(mimeHeaders);
        String boundaryIdentifier = AS2PatternMatchers.findBoundaryIdentifierFrom(mimeHeaders.getContentType());
        mimePart.setBoundaryIdentifier(boundaryIdentifier);
        int boundaryEndPaddedLength = (BOUNDARY_PREFIX + boundaryIdentifier + BOUNDARY_SUFFIX).length();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(is, boundaryEndPaddedLength);
        do {
            inputStream = new MimeBoundaryAwareInputStream(pushbackInputStream, boundaryIdentifier);
            MimePart childMimePart = mimeParserController.parse(inputStream);
            childMimePart.setBoundaryIdentifier(boundaryIdentifier);
            mimePart.addMimePart(childMimePart);
        } while (inputStream.hasMoreParts());
        LOGGER.trace("Finished parsing MIME Multipart");
        return mimePart;
    }
}

