/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.utils;

import com.mulesoft.connector.as2.internal.utils.AS2FipsUtil;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2BouncyCastleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2BouncyCastleProvider.class);
    private static AS2BouncyCastleProvider instance = null;
    private Provider bouncyCastleProvider;

    private AS2BouncyCastleProvider() {
        if (AS2FipsUtil.isFipsMode()) {
            LOGGER.info("Fips mode detected. Using BCFIPS provider");
            this.bouncyCastleProvider = AS2FipsUtil.getFipsProvider();
        } else {
            this.bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider(this.bouncyCastleProvider);
        }
    }

    public static Provider getBouncyCastleProvider() {
        if (instance == null) {
            instance = new AS2BouncyCastleProvider();
        }
        return AS2BouncyCastleProvider.instance.bouncyCastleProvider;
    }
}

