/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.enums;

import com.mulesoft.connector.as2.internal.enums.FipsValidableAlgorithm;

public enum EncryptionAlgorithm implements FipsValidableAlgorithm
{
    DES(EncryptionAlgorithm.getFipsBehavior("DES", false)),
    DES_EDE3(EncryptionAlgorithm.getFipsBehavior("DES_EDE3", false)),
    RC2(EncryptionAlgorithm.getFipsBehavior("RC2", false)),
    AES128_CBC(EncryptionAlgorithm.getFipsBehavior("AES128_CBC", true)),
    AES192_CBC(EncryptionAlgorithm.getFipsBehavior("AES192_CBC", true)),
    AES256_CBC(EncryptionAlgorithm.getFipsBehavior("AES256_CBC", true)),
    AES128_CCM(EncryptionAlgorithm.getFipsBehavior("AES128_CCM", true)),
    AES192_CCM(EncryptionAlgorithm.getFipsBehavior("AES192_CCM", true)),
    AES256_CCM(EncryptionAlgorithm.getFipsBehavior("AES256_CCM", true)),
    AES128_GCM(EncryptionAlgorithm.getFipsBehavior("AES128_GCM", true)),
    AES192_GCM(EncryptionAlgorithm.getFipsBehavior("AES192_GCM", true)),
    AES256_GCM(EncryptionAlgorithm.getFipsBehavior("AES256_GCM", true)),
    AES256_WRAP(EncryptionAlgorithm.getFipsBehavior("AES256_WRAP", false)),
    CAST5(EncryptionAlgorithm.getFipsBehavior("CAST5", false)),
    UNENCRYPTED(EncryptionAlgorithm.getFipsBehavior("UNENCRYPTED", true));

    private boolean isFipsCompliant;
    private static final String FORCE_ALG_FIPS_BEHAVIOR_PROP = "mule.as2.is_%s_fips_compliant";

    private EncryptionAlgorithm(boolean isFipsCompliant) {
        this.isFipsCompliant = isFipsCompliant;
    }

    @Override
    public boolean isFipsCompliant() {
        return this.isFipsCompliant;
    }

    @Override
    public String getName() {
        return this.name();
    }

    private static boolean getFipsBehavior(String encryptionAlgorithm, boolean defaultBehavior) {
        return defaultBehavior;
    }

    public static EncryptionAlgorithm findByAlgorithm(String algorithm) {
        for (EncryptionAlgorithm currentAlgorithm : EncryptionAlgorithm.values()) {
            if (!currentAlgorithm.name().equalsIgnoreCase(algorithm)) continue;
            return currentAlgorithm;
        }
        return null;
    }
}

