/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms.bc;

import org.bouncycastle.shaded.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.shaded.asn1.ASN1OctetString;
import org.bouncycastle.shaded.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.PasswordRecipientInfoGenerator;
import org.bouncycastle.shaded.cms.bc.CMSUtils;
import org.bouncycastle.shaded.cms.bc.EnvelopedDataHelper;
import org.bouncycastle.shaded.crypto.PBEParametersGenerator;
import org.bouncycastle.shaded.crypto.Wrapper;
import org.bouncycastle.shaded.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.shaded.crypto.params.KeyParameter;
import org.bouncycastle.shaded.crypto.params.ParametersWithIV;
import org.bouncycastle.shaded.operator.GenericKey;

public class BcPasswordRecipientInfoGenerator
extends PasswordRecipientInfoGenerator {
    public BcPasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        super(aSN1ObjectIdentifier, cArray);
    }

    @Override
    protected byte[] calculateDerivedKey(int n, AlgorithmIdentifier algorithmIdentifier, int n2) throws CMSException {
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(algorithmIdentifier.getParameters());
        byte[] byArray = n == 0 ? PBEParametersGenerator.PKCS5PasswordToBytes(this.password) : PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.password);
        try {
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(EnvelopedDataHelper.getPRF(pBKDF2Params.getPrf()));
            pKCS5S2ParametersGenerator.init(byArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
            return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n2)).getKey();
        }
        catch (Exception exception) {
            throw new CMSException("exception creating derived key: " + exception.getMessage(), exception);
        }
    }

    @Override
    public byte[] generateEncryptedBytes(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, GenericKey genericKey) throws CMSException {
        byte[] byArray2 = ((KeyParameter)CMSUtils.getBcKey(genericKey)).getKey();
        Wrapper wrapper = EnvelopedDataHelper.createRFC3211Wrapper(algorithmIdentifier.getAlgorithm());
        wrapper.init(true, new ParametersWithIV(new KeyParameter(byArray), ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets()));
        return wrapper.wrap(byArray2, 0, byArray2.length);
    }
}

