/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.codec;

import com.mulesoft.connector.as2.internal.codec.Encoding;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.stream.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodecInputStream.class);
    private final Buffer encodedBuffer = new Buffer();
    private boolean closed = false;
    private final Encoding encoding;
    private final PushbackInputStream in;
    private final boolean decode;

    public static CodecInputStreamBuilder builder(InputStream in, boolean decode) {
        return new CodecInputStreamBuilder(in, decode);
    }

    private CodecInputStream(InputStream in, Encoding encoding, boolean decode) {
        this.in = new PushbackInputStream(in, 2);
        this.encoding = encoding;
        this.decode = decode;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            LOGGER.debug("CodecInputStream is closed.");
            throw new IOException("Stream is closed");
        }
        if (!this.encodedBuffer.hasMoreData()) {
            if (this.decode) {
                this.encodedBuffer.reload(this.encoding.decode(this.in));
            } else {
                this.encodedBuffer.reload(this.encoding.encode(this.in));
            }
        }
        if (this.encodedBuffer.hasMoreData()) {
            return this.encodedBuffer.read() & 0xFF;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        return this.encodedBuffer.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    Encoding getEncoding() {
        return this.encoding;
    }

    boolean isDecode() {
        return this.decode;
    }

    public static class CodecInputStreamBuilder {
        private InputStream in;
        private EncodingType contentTransferEncoding;
        private boolean decode = false;

        public CodecInputStreamBuilder(InputStream in, boolean decode) {
            this.in = in;
            this.decode = decode;
        }

        public CodecInputStreamBuilder withEncoding(EncodingType contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
            return this;
        }

        public InputStream build() {
            Encoding encoding = Encoding.getEncodingForType(this.contentTransferEncoding);
            if (encoding != null) {
                LOGGER.debug(String.format("encoding is: %s", encoding));
                return new CodecInputStream(this.in, encoding, this.decode);
            }
            LOGGER.debug("Returning InputStream without Encoding");
            return this.in;
        }
    }
}

