/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime.parse;

import com.mulesoft.connector.as2.internal.mime.parse.FIFOByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeBoundaryAwareInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeBoundaryAwareInputStream.class);
    private static final String FIRST_BOUNDARY_MARKER_PATTERN = "--%s";
    private static final String BOUNDARY_MARKER_PATTERN = "\r\n--%s\r\n";
    private static final String BOUNDARY_MARKER_PATTERN_CR = "\r--%s\r";
    private static final String BOUNDARY_MARKER_PATTERN_LF = "\n--%s\n";
    private static final String BOUNDARY_END_MARKER_PATTERN = "\r\n--%s--\r\n";
    private static final String BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_1 = "\r\n--%s--";
    private static final String BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_2 = "\r--%s--";
    private static final String BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_3 = "\n--%s--";
    private static final String BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_4 = "\r--%s--\r";
    private static final String BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_5 = "\n--%s--\n";
    private String firstBoundaryMarker;
    private String boundaryMarker;
    private String boundaryMarkerCr;
    private String boundaryMarkerLf;
    private String boundaryEndMarker;
    private Collection<String> boundaryEndMarkerWithoutCrlf;
    private FIFOByteBuffer fifoBuffer;
    private PushbackInputStream originalInputStream;
    private boolean hasMoreParts;

    public MimeBoundaryAwareInputStream(PushbackInputStream is, String boundaryIdentifier) throws IOException {
        this.firstBoundaryMarker = String.format(FIRST_BOUNDARY_MARKER_PATTERN, boundaryIdentifier);
        this.boundaryMarker = String.format(BOUNDARY_MARKER_PATTERN, boundaryIdentifier);
        this.boundaryMarkerCr = String.format(BOUNDARY_MARKER_PATTERN_CR, boundaryIdentifier);
        this.boundaryMarkerLf = String.format(BOUNDARY_MARKER_PATTERN_LF, boundaryIdentifier);
        this.boundaryEndMarker = String.format(BOUNDARY_END_MARKER_PATTERN, boundaryIdentifier);
        this.boundaryEndMarkerWithoutCrlf = new ArrayList<String>();
        this.boundaryEndMarkerWithoutCrlf.add(String.format(BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_1, boundaryIdentifier));
        this.boundaryEndMarkerWithoutCrlf.add(String.format(BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_2, boundaryIdentifier));
        this.boundaryEndMarkerWithoutCrlf.add(String.format(BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_3, boundaryIdentifier));
        this.boundaryEndMarkerWithoutCrlf.add(String.format(BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_4, boundaryIdentifier));
        this.boundaryEndMarkerWithoutCrlf.add(String.format(BOUNDARY_END_MARKER_PATTERN_WITHOUT_CRLF_5, boundaryIdentifier));
        this.fifoBuffer = new FIFOByteBuffer(this.boundaryEndMarker.length());
        this.originalInputStream = is;
        this.stripFirstBoundaryMarker(is);
    }

    private void stripFirstBoundaryMarker(PushbackInputStream is) throws IOException {
        LOGGER.trace("striping First Boundary Marker");
        FIFOByteBuffer firstBoundaryBuffer = new FIFOByteBuffer(this.firstBoundaryMarker.length());
        firstBoundaryBuffer.fillFifoBuffer(is);
        String bufferAsString = new String(firstBoundaryBuffer.getBytes());
        int nextByte = 0;
        while (!bufferAsString.equals(this.firstBoundaryMarker) && nextByte != -1) {
            nextByte = is.read();
            firstBoundaryBuffer.pushPull(nextByte);
            bufferAsString = new String(firstBoundaryBuffer.getBytes());
        }
        if (nextByte == -1) {
            return;
        }
        nextByte = is.read();
        if (nextByte == -1) {
            return;
        }
        if (nextByte == 13) {
            nextByte = is.read();
            if (nextByte == -1) {
                return;
            }
            if (nextByte != 10) {
                LOGGER.warn("The line break should be CRLf and it is only CR");
                is.unread(nextByte);
            }
        } else if (nextByte == 10) {
            LOGGER.warn("The line break should be CRLf and it is only Lf");
        } else {
            LOGGER.error("There is no line break after the first boundary marker");
            throw new RuntimeException("No line break after the first boundary marker");
        }
        LOGGER.trace("Finish First Boundary Marker Process");
    }

    @Override
    public int read() throws IOException {
        if (this.originalInputStream == null) {
            return -1;
        }
        int byteToRead = -1;
        if (this.fifoBuffer.isBufferEmpty() && this.fifoBuffer.fillFifoBuffer(this.originalInputStream) == -1) {
            return -1;
        }
        String bufferAsString = new String(this.fifoBuffer.getBytes());
        if (bufferAsString.equals(this.boundaryEndMarker)) {
            int i = this.originalInputStream.read();
            while (i >= 0) {
                i = this.originalInputStream.read();
            }
            this.originalInputStream = null;
            this.hasMoreParts = false;
            return -1;
        }
        if (bufferAsString.startsWith(this.boundaryMarker) || bufferAsString.startsWith(this.boundaryMarkerCr) || bufferAsString.startsWith(this.boundaryMarkerLf)) {
            this.originalInputStream.unread(this.fifoBuffer.getBytes());
            this.originalInputStream = null;
            this.hasMoreParts = true;
            return -1;
        }
        int byteRead = this.originalInputStream.read();
        if (byteRead == -1 && this.boundaryEndMarkerWithoutCrlf.contains(bufferAsString)) {
            this.originalInputStream = null;
            this.hasMoreParts = false;
            return -1;
        }
        byteToRead = this.fifoBuffer.pushPull(byteRead);
        return byteToRead;
    }

    boolean hasMoreParts() {
        return this.hasMoreParts;
    }

    String getBoundaryMarker() {
        return this.boundaryMarker;
    }

    String getBoundaryEndMarker() {
        return this.boundaryEndMarker;
    }

    FIFOByteBuffer getFifoBuffer() {
        return this.fifoBuffer;
    }

    public void unread(int b) throws IOException {
        int byteToUnread = this.fifoBuffer.unread(b);
        this.originalInputStream.unread(byteToUnread);
    }
}

