/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.utils;

import com.mulesoft.connector.as2.internal.enums.FipsValidableAlgorithm;
import com.mulesoft.connector.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.error.exception.FipsComplianceException;
import com.mulesoft.connector.as2.internal.utils.AS2PatternMatchers;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2FipsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2FipsUtil.class);
    private static final String ENVELOPED_DATA = "enveloped-data";
    public static final String APPLICATION_PKCS7_MIME = "application/pkcs7-mime";
    private static final String BC_FIPS_PROVIDER = "BCFIPS";
    private static final String ALLOW_MULTI_USE = "org.bouncycastle.rsa.allow_multi_use";
    private static final String MULE_SECURITY_MODEL = "mule.security.model";
    private static final String FORCE_OAEP = "com.mulesoft.force_oeap";
    private static final String FORCE_ALGORITHM_FIPS_VALIDATION = "com.mulesoft.force_alg_fips_validation";
    private static final String FIPS1402_MODEL = "fips140-2";
    private static final String EXCEPTION_MSG = "Error trying to use the same private key both to decrypt the incoming message and to sign the mdn in fips mode.";
    private static final String SAME_ALIAS_WARN_MSG = "Using the same private key for both decrypting the incoming message and signing the mdn is a discouraged practice.";
    private static final String SAME_ALIAS_ERROR_MSG = "Using the same private key for both decrypting the incoming message and signing the mdn is not a fips-compliant practice.";
    private static final String ALGORITHM_NOT_ALLOWED_EXCEPTION_MSG = "The algorithm %s is not FIPS compliant";

    public static void validateDifferentKeyCompliance(PrivateKey aKey, PrivateKey otherKey, Map<String, String> httpHeaders) throws AS2ExtensionException {
        if (AS2FipsUtil.isFipsMode() && !AS2FipsUtil.allowMultiUse() && AS2FipsUtil.isEncyptedMessage(httpHeaders.get("Content-Type")) && AS2FipsUtil.isMDNSigned(httpHeaders.get("Disposition-Notification-Options")) && aKey != null && otherKey != null && aKey.equals(otherKey)) {
            throw new AS2ExtensionException(EXCEPTION_MSG);
        }
    }

    public static void checkAndLogDifferentKeyCompliance(PrivateKey aKey, PrivateKey otherKey) {
        if (aKey != null && otherKey != null && aKey.equals(otherKey)) {
            if (AS2FipsUtil.isFipsMode() && !AS2FipsUtil.allowMultiUse()) {
                LOGGER.error(SAME_ALIAS_ERROR_MSG);
            } else {
                LOGGER.warn(SAME_ALIAS_WARN_MSG);
            }
        }
    }

    public static void validateAlgorithm(FipsValidableAlgorithm fipsValidableAlgorithm, boolean forced) throws FipsComplianceException {
        if ((AS2FipsUtil.isFipsMode() || AS2FipsUtil.isAlgorithmFipsValidationForcedBySysProp() || forced) && !fipsValidableAlgorithm.isFipsCompliant()) {
            throw new FipsComplianceException(String.format(ALGORITHM_NOT_ALLOWED_EXCEPTION_MSG, fipsValidableAlgorithm.getName()));
        }
    }

    public static void validateAlgorithm(FipsValidableAlgorithm fipsValidableAlgorithm) throws FipsComplianceException {
        AS2FipsUtil.validateAlgorithm(fipsValidableAlgorithm, false);
    }

    public static boolean isFipsMode() {
        return FIPS1402_MODEL.equals(System.getProperty(MULE_SECURITY_MODEL));
    }

    public static boolean isOEAPForced() {
        return Boolean.valueOf(System.getProperty(FORCE_OAEP));
    }

    public static boolean isAlgorithmFipsValidationForcedBySysProp() {
        return Boolean.valueOf(System.getProperty(FORCE_ALGORITHM_FIPS_VALIDATION));
    }

    public static boolean allowMultiUse() {
        return Boolean.getBoolean(ALLOW_MULTI_USE);
    }

    public static Provider getFipsProvider() {
        return Security.getProvider(BC_FIPS_PROVIDER);
    }

    private static boolean isEncyptedMessage(String contentType) {
        if (contentType == null) {
            return false;
        }
        String sMimeType = AS2PatternMatchers.findSMimeTypeFrom(contentType);
        if (contentType.toLowerCase().startsWith(APPLICATION_PKCS7_MIME) && sMimeType != null) {
            return sMimeType.equalsIgnoreCase(ENVELOPED_DATA);
        }
        return false;
    }

    private static boolean isMDNSigned(String dispositionNotificationOption) {
        return AS2PatternMatchers.findMicAlgorithmFrom(dispositionNotificationOption) != HashAlgorithm.UNSIGNED;
    }
}

