/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.connection.provider;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import java.util.function.Function;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.connection.provider.AWSConnectionProvider;
import org.mule.extension.aws.commons.internal.connection.provider.parameter.CommonParameters;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class AssumeRoleConnectionProvider<AWS_CLIENT, AWS_CLIENT_BUILDER extends AwsClientBuilder<AWS_CLIENT_BUILDER, AWS_CLIENT>, CONNECTION extends AWSConnection<AWS_CLIENT>>
extends AWSConnectionProvider<AWS_CLIENT, AWS_CLIENT_BUILDER, CONNECTION> {
    @Parameter
    @DisplayName(value="Role ARN")
    @Placement(order=1)
    private String roleARN;

    public AssumeRoleConnectionProvider(Function<AWS_CLIENT, CONNECTION> connectionConstructor, AWS_CLIENT_BUILDER clientBuilder) {
        super(connectionConstructor, clientBuilder);
    }

    @Override
    protected AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters commonParameters) {
        AssumeRoleResult assumeResult = (commonParameters.isTryDefaultAWSCredentialsProviderChain() ? new AWSSecurityTokenServiceClient() : new AWSSecurityTokenServiceClient((AWSCredentials)new BasicAWSCredentials(commonParameters.getAccessKey(), commonParameters.getSecretKey()))).assumeRole(new AssumeRoleRequest().withRoleArn(this.roleARN).withDurationSeconds(Integer.valueOf(3600)).withRoleSessionName("WithRoleARN"));
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken()));
    }
}

