/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.connection.provider;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.metrics.AwsSdkMetrics;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.connection.provider.parameter.CommonParameters;
import org.mule.extension.aws.commons.internal.connection.provider.parameter.ProxyParameterGroup;
import org.mule.extension.aws.commons.internal.exception.AWSConnectionException;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public abstract class AWSConnectionProvider<AWS_CLIENT, AWS_CLIENT_BUILDER extends AwsClientBuilder<AWS_CLIENT_BUILDER, AWS_CLIENT>, CONNECTION extends AWSConnection<AWS_CLIENT>>
implements CachedConnectionProvider<CONNECTION> {
    private final AWS_CLIENT_BUILDER clientBuilder;
    private final Function<AWS_CLIENT, CONNECTION> connectionConstructor;
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private CommonParameters commonParameters;
    @ParameterGroup(name="Proxy")
    @Placement(order=2)
    private ProxyParameterGroup proxyParameterGroup;

    public AWSConnectionProvider(Function<AWS_CLIENT, CONNECTION> connectionConstructor, AWS_CLIENT_BUILDER clientBuilder) {
        this.connectionConstructor = connectionConstructor;
        this.clientBuilder = clientBuilder;
    }

    public CONNECTION connect() throws ConnectionException {
        try {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            if (this.proxyParameterGroup != null) {
                Optional.ofNullable(this.proxyParameterGroup.getProxyDomain()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyDomain(arg_0));
                Optional.ofNullable(this.proxyParameterGroup.getProxyUsername()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyUsername(arg_0));
                Optional.ofNullable(this.proxyParameterGroup.getProxyHost()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyHost(arg_0));
                Optional.ofNullable(this.proxyParameterGroup.getProxyPassword()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyPassword(arg_0));
                Optional.ofNullable(this.proxyParameterGroup.getProxyPort()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyPort(arg_0));
                Optional.ofNullable(this.proxyParameterGroup.getProxyWorkstation()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyWorkstation(arg_0));
            }
            clientConfiguration.setSocketTimeout(this.commonParameters.getSocketTimeout().intValue());
            clientConfiguration.setConnectionTimeout(this.commonParameters.getConnectionTimeout().intValue());
            this.clientBuilder.setRegion(this.commonParameters.getRegion().toString());
            this.appendClientConfigurationProperties(clientConfiguration);
            this.clientBuilder.withClientConfiguration(clientConfiguration);
            if (!(this.commonParameters.isTryDefaultAWSCredentialsProviderChain() || Optional.ofNullable(this.commonParameters.getAccessKey()).filter(Predicate.isEqual("").negate()).isPresent() && Optional.ofNullable(this.commonParameters.getSecretKey()).filter(Predicate.isEqual("").negate()).isPresent())) {
                throw new AWSConnectionException("Access Key or Secret Key is blank");
            }
            this.clientBuilder.withCredentials(this.getAWSCredentialsProvider(this.commonParameters));
            this.appendBuilderProperties(this.clientBuilder);
            AwsSdkMetrics.unregisterMetricAdminMBean();
            AWSConnection connection = (AWSConnection)this.connectionConstructor.apply(this.clientBuilder.build());
            this.onConnect(connection);
            return (CONNECTION)connection;
        }
        catch (AWSConnectionException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    protected void onConnect(CONNECTION connection) {
    }

    protected void appendBuilderProperties(AWS_CLIENT_BUILDER clientBuilder) {
    }

    protected abstract AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters var1);

    protected void appendClientConfigurationProperties(ClientConfiguration configuration) {
    }

    public void disconnect(CONNECTION connection) {
        ((AWSConnection)connection).disconnect();
    }

    public ConnectionValidationResult validate(CONNECTION connection) {
        try {
            ((AWSConnection)connection).validate();
            return ConnectionValidationResult.success();
        }
        catch (AWSConnectionException e) {
            return ConnectionValidationResult.failure((String)Optional.ofNullable(e.getMessage()).orElse("An unknown error has occurred."), (Exception)e);
        }
    }

    public void setCommonParameters(CommonParameters commonParameters) {
        this.commonParameters = commonParameters;
    }

    public void setProxyParameterGroup(ProxyParameterGroup proxyParameterGroup) {
        this.proxyParameterGroup = proxyParameterGroup;
    }
}

