package org.mule.extension.aws.commons.internal.connection;

import com.amazonaws.AmazonWebServiceClient;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.extension.aws.commons.internal.exception.AWSConnectionException;

public class AWSConnection<T, A> implements ConnectorConnection {
    private final T awsClient;
    private final A awsAsyncClient;

    public AWSConnection(T awsClient, A awsAsyncClient) {
        this.awsClient = awsClient;
        this.awsAsyncClient = awsAsyncClient;
    }

    public T getAwsClient() {
        return awsClient;
    }

    public A getAwsAsyncClient() {
        return awsAsyncClient;
    }

    @Override
    public void validate() throws AWSConnectionException {
        // Do nothing here.
    }

    @Override
    public void disconnect() {
        AmazonWebServiceClient.class.cast(awsClient).shutdown();
    }
}
