package org.mule.extension.aws.commons.internal.connection.provider.parameter;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public class CommonParameters {

    /**
     * The amount of time to wait (in milliseconds) when initially establishing a connection before giving up and timing out. A value of 0 means infinity, and is not recommended.
     */
    @Parameter
    @Optional(defaultValue = "50000")
    @Placement(tab = Placement.ADVANCED_TAB, order = 1)
    @DisplayName("Connection Timeout")
    @Summary("The amount of time to wait (in milliseconds) when initially establishing a connection before giving up and timing out. A value of 0 means infinity, and is not recommended.")
    private Integer connectionTimeout;

    /**
     * The amount of time to wait (in milliseconds) for data to be transferred over an established, open connection before the connection is timed out. A value of 0 means infinity,
     * and is not recommended.
     */
    @Parameter
    @Optional(defaultValue = "50000")
    @Placement(tab = Placement.ADVANCED_TAB, order = 3)
    @DisplayName("Socket Timeout")
    @Summary("The amount of time to wait (in milliseconds) for data to be transferred over an established, open connection before the connection is timed out. A value of 0 means infinity,and is not recommended.")
    private Integer socketTimeout;


    @Parameter
    @DisplayName("Access Key")
    @Placement(order = 4)
    @Summary("The access key provided by Amazon.")
    private String accessKey;

    @Parameter
    @DisplayName("Secret Key")
    @Placement(order = 5)
    @Summary("The secret key provided by Amazon.")
    private String secretKey;

    @Parameter
    @DisplayName("Try Default AWSCredentials Provider Chain")
    @Placement(order = 6)
    @Optional
    @Summary("Set this field to true to obtain credentials from AWS environment, See: https://docs.aws.amazon.com/sdk-for-java/v2/developer-guide/credentials.html")
    private boolean tryDefaultAWSCredentialsProviderChain;

    /**
     * Sets the maximum number of allowed open HTTP connections.
     */
    @Parameter
    @Optional
    @Placement(tab = Placement.ADVANCED_TAB, order = 2)
    @Summary("Sets the maximum number of allowed open HTTP connections.")
    private Integer maxConnections;

    /**
     * Set the topic region endpoint
     */
    @OfValues(RegionValuesProvider.class)
    @Optional(defaultValue = "US_EAST_1")
    @Parameter
    @DisplayName("Region Endpoint")
    @Placement(order = 7)
    @Summary("Set the topic region endpoint.")
    private String region;

    public Integer getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean isTryDefaultAWSCredentialsProviderChain() {
        return tryDefaultAWSCredentialsProviderChain;
    }

    public void setTryDefaultAWSCredentialsProviderChain(boolean tryDefaultAWSCredentialsProviderChain) {
        this.tryDefaultAWSCredentialsProviderChain = tryDefaultAWSCredentialsProviderChain;
    }

    public Integer getMaxConnections() {
        return maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getRegion() {
        if(region != null && !region.isEmpty()){
            return region.toUpperCase().replace("-", "_");
        }
        throw new IllegalArgumentException("The region is required");
    }

    public void setRegion(String region) {
        this.region = region;
    }
}
