package org.mule.extension.aws.commons.internal.connection.provider.parameter;

import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toSet;
import static org.mule.runtime.extension.api.values.ValueBuilder.newValue;

public class RegionValuesProvider implements ValueProvider {

    @Override
    public Set<Value> resolve() throws ValueResolvingException {
        return Stream.of(RegionEndpoint.values()).map(regionEndpoint -> newValue(regionEndpoint.name())
                .withDisplayName(regionEndpoint.toString())
                .build())
                .collect(toSet());
    }

}
