package org.mule.extension.aws.commons.internal.exception;

import com.amazonaws.AmazonServiceException;
import org.mule.connectors.atlantic.commons.builder.exception.ConversionException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toSet;
import static org.mule.runtime.extension.api.error.MuleErrors.ANY;

public class AWSExceptionHandler<T extends Enum<T> & ErrorTypeDefinition<T>> extends ExceptionHandler {

    private final Class<T> enumType;
    private final Set<String> stringTypes;

    public AWSExceptionHandler(Class<T> enumType) {
        this.enumType = enumType;
        stringTypes = Stream.of(enumType.getEnumConstants())
                .map(Object::toString)
                .collect(toSet());
    }

    @Override
    public Exception enrichException(Exception e) {
        return new ModuleException(Optional.of(e)
                .filter(AmazonServiceException.class::isInstance)
                .map(AmazonServiceException.class::cast)
                .map(AmazonServiceException::getErrorCode)
                .map(code -> code.replace('.', '_'))
                .filter(stringTypes::contains)
                .<ErrorTypeDefinition<?>>map(code -> Enum.valueOf(enumType, code))
                .orElse(Optional.of(e)
                        .filter(ConversionException.class::isInstance)
                        .map(Exception::getCause)
                        .map(Exception.class::cast)
                        .map(this::enrichException)
                        .map(ModuleException.class::cast)
                        .map(ModuleException::getType)
                        .orElse(ANY)), e);
    }
}
