package org.mule.extension.aws.commons.internal.operation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.connectors.commons.template.service.ConnectorService;
import org.mule.extension.aws.commons.internal.config.AWSConfig;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;

public class AWSOperations<CONFIG extends AWSConfig, CONNECTION extends AWSConnection, SERVICE extends ConnectorService> extends ConnectorOperations<CONFIG, CONNECTION, SERVICE> {

    public AWSOperations(BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructor) {
        super(serviceConstructor);
    }

    @Override
    protected ExecutionBuilder<SERVICE> newExecutionBuilder(CONFIG config, CONNECTION connection) {
        return super.newExecutionBuilder(config, connection)
                .withExceptionHandler(AmazonServiceException.class, e -> {
                    throw e;
                })
                .withExceptionHandler(AmazonClientException.class, e -> {
                    throw e;
                });
    }
}
