/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.connection.provider.parameter;

import org.mule.extension.aws.commons.internal.connection.provider.parameter.RegionValuesProvider;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public class CommonParameters {
    @Parameter
    @Optional(defaultValue="50000")
    @Placement(tab="Advanced", order=1)
    @DisplayName(value="Connection Timeout")
    @Summary(value="The amount of time to wait (in milliseconds) when initially establishing a connection before the connector gives up and times out. A value of 0 means infinity and is not recommended.")
    private Integer connectionTimeout;
    @Parameter
    @Optional(defaultValue="50000")
    @Placement(tab="Advanced", order=3)
    @DisplayName(value="Socket Timeout")
    @Summary(value="The amount of time to wait (in milliseconds) for data to be transferred over an established, open connection before the connection times out. A value of 0 means infinity and is not recommended.")
    private Integer socketTimeout;
    @Parameter
    @DisplayName(value="Access Key")
    @Placement(order=4)
    @Summary(value="The access key provided by Amazon.")
    private String accessKey;
    @Parameter
    @DisplayName(value="Secret Key")
    @Placement(order=5)
    @Summary(value="The secret key provided by Amazon.")
    private String secretKey;
    @Parameter
    @DisplayName(value="Try Default AWSCredentials Provider Chain")
    @Placement(order=6)
    @Optional
    @Summary(value="Set this field to true to obtain credentials from the AWS environment, See: https://docs.aws.amazon.com/sdk-for-java/v2/developer-guide/credentials.html")
    private boolean tryDefaultAWSCredentialsProviderChain;
    @Parameter
    @Optional
    @Placement(tab="Advanced", order=2)
    @Summary(value="Sets the maximum number of allowed open HTTP connections.")
    private Integer maxConnections;
    @OfValues(value=RegionValuesProvider.class)
    @Optional(defaultValue="US_EAST_1")
    @Parameter
    @DisplayName(value="Region Endpoint")
    @Placement(order=7)
    @Summary(value="Set the topic region endpoint.")
    private String region;

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean isTryDefaultAWSCredentialsProviderChain() {
        return this.tryDefaultAWSCredentialsProviderChain;
    }

    public void setTryDefaultAWSCredentialsProviderChain(boolean tryDefaultAWSCredentialsProviderChain) {
        this.tryDefaultAWSCredentialsProviderChain = tryDefaultAWSCredentialsProviderChain;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getRegion() {
        if (this.region != null && !this.region.isEmpty()) {
            return this.region.toUpperCase().replace("-", "_");
        }
        throw new IllegalArgumentException("The region is required.");
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

