/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.connection.provider;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.function.BiFunction;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.connection.provider.AWSConnectionProvider;
import org.mule.extension.aws.commons.internal.connection.provider.parameter.CommonParameters;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AssumeRoleConnectionProvider<AWS_CLIENT, AWS_ASYNC_CLIENT, AWS_CLIENT_BUILDER extends AwsClientBuilder<AWS_CLIENT_BUILDER, AWS_CLIENT>, AWS_ASYNC_CLIENT_BUILDER extends AwsAsyncClientBuilder<AWS_ASYNC_CLIENT_BUILDER, AWS_ASYNC_CLIENT>, CONNECTION extends AWSConnection<AWS_CLIENT, AWS_ASYNC_CLIENT>>
extends AWSConnectionProvider<AWS_CLIENT, AWS_ASYNC_CLIENT, AWS_CLIENT_BUILDER, AWS_ASYNC_CLIENT_BUILDER, CONNECTION> {
    @Parameter
    @DisplayName(value="Role ARN")
    @Placement(order=1)
    @Summary(value="The Role ARN unique identifies role to assume in order to gain cross account access.")
    private String roleARN;

    public AssumeRoleConnectionProvider(BiFunction<AWS_CLIENT, AWS_ASYNC_CLIENT, CONNECTION> connectionConstructor, AWS_CLIENT_BUILDER clientBuilder, AWS_ASYNC_CLIENT_BUILDER asyncClientBuilder) {
        super(connectionConstructor, clientBuilder, asyncClientBuilder);
    }

    @Override
    protected AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters commonParameters) throws ConnectionException {
        DefaultAWSCredentialsProviderChain credentialsProvider = commonParameters.isTryDefaultAWSCredentialsProviderChain() ? DefaultAWSCredentialsProviderChain.getInstance() : new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(commonParameters.getAccessKey(), commonParameters.getSecretKey()));
        try {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(this.roleARN, "WithRoleARN").withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withClientConfiguration(this.getClientConfiguration())).withRegion(commonParameters.getRegion())).withCredentials((AWSCredentialsProvider)credentialsProvider)).build()).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }
}

