/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.connection.provider;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.connection.provider.AWSConnectionProvider;
import org.mule.extension.aws.commons.internal.connection.provider.parameter.CommonParameters;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.security.TokenId;

public class BasicConnectionProvider<AWS_CLIENT, AWS_ASYNC_CLIENT, AWS_CLIENT_BUILDER extends AwsClientBuilder<AWS_CLIENT_BUILDER, AWS_CLIENT>, AWS_ASYNC_CLIENT_BUILDER extends AwsAsyncClientBuilder<AWS_ASYNC_CLIENT_BUILDER, AWS_ASYNC_CLIENT>, CONNECTION extends AWSConnection<AWS_CLIENT, AWS_ASYNC_CLIENT>>
extends AWSConnectionProvider<AWS_CLIENT, AWS_ASYNC_CLIENT, AWS_CLIENT_BUILDER, AWS_ASYNC_CLIENT_BUILDER, CONNECTION> {
    @Parameter
    @DisplayName(value="Session Token")
    @Placement(order=6)
    @Optional
    @Summary(value="The session token provided by Amazon STS.")
    @TokenId
    private String sessionToken;

    public BasicConnectionProvider(BiFunction<AWS_CLIENT, AWS_ASYNC_CLIENT, CONNECTION> connectionConstructor, AWS_CLIENT_BUILDER clientBuilder, AWS_ASYNC_CLIENT_BUILDER asyncClientBuilder) {
        super(connectionConstructor, clientBuilder, asyncClientBuilder);
    }

    @Override
    protected AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters commonParameters) {
        if (commonParameters.isTryDefaultAWSCredentialsProviderChain()) {
            return new DefaultAWSCredentialsProviderChain();
        }
        if (StringUtils.isBlank((CharSequence)this.sessionToken)) {
            return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(commonParameters.getAccessKey(), commonParameters.getSecretKey()));
        }
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(commonParameters.getAccessKey(), commonParameters.getSecretKey(), this.sessionToken));
    }

    @Override
    public CONNECTION connect() throws ConnectionException {
        return (CONNECTION)super.connect();
    }
}

