/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.connection;

import com.amazonaws.AmazonWebServiceClient;
import java.util.Arrays;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.extension.aws.commons.internal.exception.AWSConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSConnection<T, A>
implements ConnectorConnection {
    private static final Logger logger = LoggerFactory.getLogger(AWSConnection.class);
    private final T awsClient;
    private final A awsAsyncClient;

    public AWSConnection(T awsClient, A awsAsyncClient) {
        this.awsClient = awsClient;
        this.awsAsyncClient = awsAsyncClient;
    }

    protected T getAwsClient() {
        return this.awsClient;
    }

    protected A getAwsAsyncClient() {
        return this.awsAsyncClient;
    }

    public void validate() throws AWSConnectionException {
    }

    public void disconnect() {
        logger.debug("Shutting down AWS Client.");
        logger.trace(Arrays.toString(Thread.currentThread().getStackTrace()));
        ((AmazonWebServiceClient)this.awsClient).shutdown();
    }
}

