/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.commons.unit.mockito;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.mockito.ArgumentMatchers;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public class HttpMatchers {
    private HttpMatchers() {
    }

    public static HttpRequest request(@Nonnull HttpConstants.Method method) {
        return (HttpRequest)ArgumentMatchers.argThat(request -> request != null && HttpMatchers.matchMethod(request, method));
    }

    public static HttpRequest request(@Nonnull HttpConstants.Method method, AtomicReference<HttpRequest> capture) {
        return HttpMatchers.argWithCapture(request -> HttpMatchers.matchMethod(request, method), capture);
    }

    public static HttpRequest request(@Nonnull String uriRegex) {
        return (HttpRequest)ArgumentMatchers.argThat(request -> request != null && HttpMatchers.matchPath(request, uriRegex));
    }

    public static HttpRequest request(@Nonnull String uriRegex, AtomicReference<HttpRequest> capture) {
        return HttpMatchers.argWithCapture(request -> HttpMatchers.matchPath(request, uriRegex), capture);
    }

    public static HttpRequest request(@Nonnull HttpConstants.Method method, @Nonnull String uriRegex) {
        return (HttpRequest)ArgumentMatchers.argThat(request -> request != null && HttpMatchers.matchMethod(request, method) && HttpMatchers.matchPath(request, uriRegex));
    }

    public static HttpRequest request(@Nonnull HttpConstants.Method method, @Nonnull String uriRegex, AtomicReference<HttpRequest> capture) {
        return HttpMatchers.argWithCapture(request -> HttpMatchers.matchMethod(request, method) && HttpMatchers.matchPath(request, uriRegex), capture);
    }

    private static HttpRequest argWithCapture(Predicate<HttpRequest> condition, AtomicReference<HttpRequest> capture) {
        return (HttpRequest)ArgumentMatchers.argThat(request -> {
            if (request != null && condition.test((HttpRequest)request)) {
                capture.set((HttpRequest)request);
                return true;
            }
            return false;
        });
    }

    private static boolean matchMethod(HttpRequest request, HttpConstants.Method method) {
        return request.getMethod().equalsIgnoreCase(method.name());
    }

    private static boolean matchPath(HttpRequest request, String regex) {
        return request.getPath().matches(regex);
    }
}

