/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.hl7;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;

public class HL7Lexer
extends DelimiterLexer {
    private static final String MSH_PREFIX = "MSH";

    public HL7Lexer(InputStream is, int subst) {
        this(is, subst, '\r');
    }

    public HL7Lexer(InputStream is, int subst, char segmentTerminator) {
        super(is, -1);
        this.substitutionChar = subst;
        this.segmentTerminator = segmentTerminator;
    }

    public void handleEscape(StringBuilder builder) throws IOException {
        block15: {
            char rls;
            StringBuilder escaped;
            int code;
            block14: {
                int value;
                code = this.reader.read();
                if (code < 0) {
                    throw new LexicalException("end of input in escape sequence");
                }
                escaped = new StringBuilder();
                while ((value = this.reader.read()) >= 0 && value != this.releaseIndicator) {
                    escaped.append((char)value);
                }
                if (value < 0) {
                    throw new LexicalException("malformed escape sequence in input");
                }
                rls = (char)this.releaseIndicator;
                if (escaped.length() != 0) break block14;
                switch (code) {
                    case 69: {
                        builder.append(rls);
                        break block15;
                    }
                    case 70: {
                        builder.append(this.dataSeparator);
                        break block15;
                    }
                    case 82: {
                        builder.append((char)this.repetitionSeparator);
                        break block15;
                    }
                    case 83: {
                        builder.append(this.componentSeparator);
                        break block15;
                    }
                    case 84: {
                        builder.append((char)this.subCompSeparator);
                        break block15;
                    }
                    case 72: 
                    case 78: {
                        builder.append(rls);
                        builder.append((char)code);
                        builder.append(rls);
                        break block15;
                    }
                    default: {
                        throw new LexicalException("unsupported escape sequence code " + (char)code);
                    }
                }
            }
            switch (code) {
                case 46: 
                case 88: 
                case 90: {
                    builder.append(rls);
                    builder.append((char)code);
                    builder.append((CharSequence)escaped);
                    builder.append(rls);
                    break;
                }
                default: {
                    throw new LexicalException("unsupported escape sequence code '" + (char)code + '\'');
                }
            }
        }
    }

    public void setEncoding(Charset charSet) {
        this.reader = new InputStreamReader(this.stream, charSet);
    }

    public String init(Map<String, Object> props) throws LexicalException {
        try {
            this.validateSegmentIsMSH();
            byte[] msh01Buffer = this.parseSeparatorAndEncodingCharacters();
            this.validateDataSeparatorMatches();
            this.configureReaderAndAdvance();
            return new String(msh01Buffer, EdiConstants.ASCII_CHARSET);
        }
        catch (IOException e) {
            String msg = this.buildExceptionMessage(e);
            throw new LexicalException(String.format("Unable to parse segment header: %s", msg), (Throwable)e);
        }
    }

    private void validateSegmentIsMSH() throws LexicalException {
        try {
            byte[] segmentHeaderBuffer = this.readBytes(3);
            String segmentHeader = new String(segmentHeaderBuffer, EdiConstants.ASCII_CHARSET);
            if (!MSH_PREFIX.equals(segmentHeader)) {
                throw new RuntimeException("Message does not start with 'MSH'");
            }
        }
        catch (IOException e) {
            String msg = this.buildExceptionMessage(e);
            throw new LexicalException(String.format("Message aborted when validating MSH header: %s", msg), (Throwable)e);
        }
    }

    private byte[] parseSeparatorAndEncodingCharacters() throws LexicalException {
        try {
            byte[] segmentBuffer = this.readBytes(5);
            this.dataSeparator = (char)segmentBuffer[0];
            this.componentSeparator = (char)segmentBuffer[1];
            this.repetitionSeparator = (char)segmentBuffer[2];
            this.releaseIndicator = (char)segmentBuffer[3];
            this.subCompSeparator = (char)segmentBuffer[4];
            return segmentBuffer;
        }
        catch (IOException e) {
            String msg = this.buildExceptionMessage(e);
            throw new LexicalException(String.format("Message aborted when parsing separator and encoding characters: %s", msg), (Throwable)e);
        }
    }

    private void validateDataSeparatorMatches() throws LexicalException {
        try {
            int nextChar = this.stream.read();
            if (nextChar == -1) {
                throw new RuntimeException("Field separator not present following MSH-01");
            }
            if (nextChar != this.dataSeparator) {
                throw new RuntimeException("Field separator does not match following MSH-01");
            }
        }
        catch (IOException e) {
            String msg = this.buildExceptionMessage(e);
            throw new LexicalException(String.format("Message aborted when validating data separator: %s", msg), (Throwable)e);
        }
    }

    private void configureReaderAndAdvance() throws LexicalException {
        try {
            this.segmentTag = MSH_PREFIX;
            this.reader = new ByteReader();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            this.elementNumber = 2;
        }
        catch (IOException e) {
            String msg = this.buildExceptionMessage(e);
            throw new LexicalException(String.format("Message aborted when advancing to MSH-3 field: %s", msg), (Throwable)e);
        }
    }

    private String buildExceptionMessage(Exception e) {
        return e.getMessage() != null ? e.getMessage() : String.format("An exception of type %s was thrown.", e.getClass().getName());
    }

    public void term(Map<String, Object> props) throws IOException {
    }

    private class ByteReader
    extends Reader {
        private ByteReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int chr;
            int actual = -1;
            while (actual < len - 1 && (chr = HL7Lexer.this.stream.read()) >= 0) {
                cbuf[off + ++actual] = (char)chr;
            }
            return actual;
        }

        @Override
        public void close() throws IOException {
            HL7Lexer.this.stream.close();
        }
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }
}

